import logging
import evdev
import threading
import queue
import time

logger = logging.getLogger(__name__)

class KeyboardAvailablePlugin(object):
    def __init__(self):
        logger.info('created keyboard_available plugin instance')
        self.keyboard_available = False

    def find_keyboard(self):
        self.keyboard_available = False
        devices = [evdev.InputDevice(path) for path in evdev.list_devices()]
        for device in devices:
            logger.info(f'examining device: {device.name}')
            if 'keyboard' in device.name.lower():
                self.keyboard_available = True
                logger.info(f'keyboard found: {device.name}')
                break
        time.sleep (0.1)

    def handle(self, bytes):
        try:
            self.find_keyboard()
            if self.keyboard_available:
                r = 1
            else:
                r = 0

            logger.info(f'handled keyboard_available plugin message, returning {r}')
            return [r]

        except Exception as e:
            logger.error(f'something went wrong: {e}')
            return []
