# 1 "main.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "main.c"

# 1 "/libti99/vdp.h" 1
# 29 "/libti99/vdp.h"
inline void VDP_SAFE_DELAY() { }


inline void VDP_SET_ADDRESS(unsigned int x) { *((volatile unsigned char*)0x8C02)=((x)&0xff); *((volatile unsigned char*)0x8C02)=((x)>>8); }


inline void VDP_SET_ADDRESS_WRITE(unsigned int x) { *((volatile unsigned char*)0x8C02)=((x)&0xff); *((volatile unsigned char*)0x8C02)=(((x|0x4000)>>8)); }


inline void VDP_SET_REGISTER(unsigned char r, unsigned char v) { *((volatile unsigned char*)0x8C02)=(v); *((volatile unsigned char*)0x8C02)=(0x80|(r)); }


inline int VDP_SCREEN_POS(unsigned int r, unsigned int c) { return (((r)<<5)+(c)); }


inline int VDP_SCREEN_TEXT(unsigned int r, unsigned int c) { return (((r)<<5)+((r)<<3)+(c)); }


inline int VDP_SCREEN_TEXT80(unsigned int r, unsigned int c) { return (((r)<<6)+((r)<<4)+(c)); }




inline int VDP_SCREEN_TEXT64(unsigned int r, unsigned int c) { return (((r)<<6)+(c)); }
# 179 "/libti99/vdp.h"
int set_graphics_raw(int sprite_mode);

void set_graphics(int sprite_mode);





int set_text_raw();

void set_text();





int set_text80_raw();

void set_text80();







int set_text80_color_raw();

void set_text80_color();







int set_text80x30_color_raw();

void set_text80x30_color();





void set_text64_color();







int set_multicolor_raw(int sprite_mode);

void set_multicolor(int sprite_mode);





int set_bitmap_raw(int sprite_mode);

void set_bitmap(int sprite_mode);




void writestring(int row, int col, char *pStr);



void vdpmemset(int pAddr, int ch, int cnt);



void vdpmemcpy(int pAddr, const unsigned char *pSrc, int cnt);



void vdpmemread(int pAddr, unsigned char *pDest, int cnt);





void vdpwriteinc(int pAddr, int nStart, int cnt);




extern void (*vdpchar)(int pAddr, int ch);
void vdpchar_default(int pAddr, int ch);




unsigned char vdpreadchar(int pAddr);



void vdpwritescreeninc(int pAddr, int nStart, int cnt);



void vdpscreenchar(int pAddr, int ch);



void vdpwaitvint();







int putchar(int x);







void putstring(char *s);
# 317 "/libti99/vdp.h"
void hexprint(unsigned char x);



void fast_hexprint(unsigned char x);



void faster_hexprint(unsigned char x);



void scrn_scroll_default();
extern void (*scrn_scroll)();


void fast_scrn_scroll();




void hchar(int r, int c, int ch, int cnt);




void vchar(int r, int c, int ch, int cnt);




unsigned char gchar(int r, int c);






void sprite(int n, int ch, int col, int r, int c);



void delsprite(int n);



void charset();




void charsetlc();
# 377 "/libti99/vdp.h"
void gplvdp(int vect, int adr, int cnt);


void bm_setforeground(int c);


void bm_setbackground(int c);



void bm_clearscreen();




void bm_setpixel(unsigned int x, unsigned int y);




void bm_clearpixel(unsigned int x, unsigned int y);


void bm_drawline(int x0, int y0, int x1, int y1, int mode);







void bm_drawlinefast(int x0, int y0, int x1, int y1, int mode);



void bm_sethlinefast(unsigned int x0, unsigned int y0, unsigned int x1);


void bm_clearhlinefast(unsigned int x0, unsigned int y0, unsigned int x1);




void bm_consolefont();




void bm_putc(int c, int r, unsigned char alphanum);





void bm_puts(int c, int r, unsigned char* str);




void bm_placetile(int c, int r, const unsigned char* pattern);






extern unsigned char gBitmapColor;





extern unsigned char* gBmFont;




extern unsigned int gImage;
extern unsigned int gColor;
extern unsigned int gPattern;
extern unsigned int gSprite;
extern unsigned int gSpritePat;


extern int nTextRow,nTextEnd;
extern int nTextPos,nTextFlags;
# 477 "/libti99/vdp.h"
extern unsigned char gSaveIntCnt;


extern const unsigned int byte2hex[256];



void unlock_f18a();


void lock_f18a();
# 3 "main.c" 2
# 1 "/libti99/system.h" 1
# 9 "/libti99/system.h"
void halt() __attribute__ ((noreturn));


void exit() __attribute__ ((noreturn));


void checkquit();
# 4 "main.c" 2
# 1 "/libti99/string.h" 1







int strlen(const char *s);



int atoi(char *s);


char *strcpy(char *d, const char *s);


char *strncpy(char *d, const char *s, int len);



int strcmp(const char *s1, const char *s2);



int memcmp(const void *s1, const void *s2, int n);


void *memcpy(void *dest, const void *src, int cnt);


void *memset(void *dest, int src, int cnt);



char *uint2str(unsigned int x);



char *int2str(int x);



char* uint2hex(unsigned int x);




void gets(char *buf, int maxlen);
# 5 "main.c" 2



extern char mcolor;
extern char scolor;
extern char fcolor;





int try_limit;
int corcompCru;

void __attribute__ ((noinline)) writehex(unsigned int row, unsigned int col, const unsigned int value) {
  unsigned char buf[3] = { 0, 0, 0 };
  *((unsigned int*)buf) = byte2hex[value >> 8];
  writestring(row, col, buf);
  *((unsigned int*)buf) = byte2hex[0xFF & value];
  writestring(row, col + 2, buf);
}

void __attribute__ ((noinline)) printSummary(int ec) {
  if (ec == 0) {
    VDP_SET_REGISTER(0x07, scolor);
    writestring(21, 11, "All Memory Passed");
  } else {
    VDP_SET_REGISTER(0x07, fcolor);
    writestring(21, 14, "Found errors");
  }
}

int __attribute__ ((noinline)) testBlock(const unsigned int row, unsigned char* addr) {
  int ec = 0;
  unsigned int* end=(unsigned int*)(addr + 0x1FFF);
  writestring(row, 3, "Testing");
  writehex(row, 11, (int)addr);
  writestring(row, 16, "->");
  writehex(row, 19, (int)end);
  writestring(row, 24, ":");
  writestring(row, 26, "      ");

  const char spinner[4] = { '-', '\\', '|', '/' };
  int spinneridx = 0;

  for( int tries=0; tries<try_limit; tries++) {


    vdpchar(VDP_SCREEN_TEXT(row, 26), spinner[spinneridx++ % 4]);
    unsigned int val = 0x0000;

    for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
      *a = val;
      val++;
    }

    val = 0x0000;
    for (volatile unsigned int *a = (unsigned int *)addr; a <= end; a++) {
      if (*a != val) {
        ec++;
      }
      val++;
    }

    if (try_limit > 1) {

      vdpchar(VDP_SCREEN_TEXT(row, 26), spinner[spinneridx++ % 4]);
      val = 0x0000;

      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        *a = ~val;
        val++;
      }

      val = 0x0000;
      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        if ( *a != ~val ) {
        ec++;
        }
        val++;
      }


      vdpchar(VDP_SCREEN_TEXT(row, 26), spinner[spinneridx++ % 4]);
      val = 0x8000;

      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        for( unsigned char i = 0; i<<8; i++) {
          *a = val;
          if (*a != val) {
            ec++;
          }
          val = val << i;
        }
      }

      vdpchar(VDP_SCREEN_TEXT(row, 26), spinner[spinneridx++ % 4]);
      val = 0xA5A5;
      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        *a = val;
      }

      val = 0xA5A5;
      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        if ( *a != val ) {
        ec++;
        }
      }

      vdpchar(VDP_SCREEN_TEXT(row, 26), spinner[spinneridx++ % 4]);
      val = ~0xA5A5;
      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        *a = val;
      }

      val = ~0xA5A5;
      for( volatile unsigned int* a=(unsigned int*)addr; a<=end; a++ ) {
        if ( *a != val ) {
        ec++;
        }
      }
    }
  }

  if (ec == 0) {
    writestring(row, 26, "PASSED");
  } else {
    writestring(row, 26, "FAILED");
  }

  return ec;
}

int __attribute__ ((noinline)) hasRam() {
  volatile int* lower_exp = (volatile int*) 0x2000;
  *lower_exp = 0;
  *lower_exp = 0x1234;
  return (*lower_exp == 0x1234);
}




void __attribute__ ((noinline)) foundationBank(int page, int crubase) {
  int adjusted = page << 8;

  __asm__(
    "MOV %1, r12\n\t"
    "LDCR %0,4\n\t"
    : : "r"(adjusted), "r"(crubase+2) : "r12"
  );
}

int __attribute__ ((noinline)) hasFoundation(int crubase) {
  volatile int* lower_exp = (volatile int*) 0x2000;
  foundationBank(0, crubase);
  *lower_exp = 0x1234;
  foundationBank(1, crubase);
  *lower_exp = 0;
  foundationBank(0, crubase);
  return (*lower_exp == 0x1234);
}

int __attribute__ ((noinline)) foundationPagecount(int crubase) {
  volatile int* lower_exp = (volatile int*) 0x2000;
  for(int i = 0; i < 16; i++) {
    foundationBank(i, crubase);
    *lower_exp = 0x1234;
  }
  foundationBank(0, crubase);
  int pages = 0;
  while(pages < 16 && *lower_exp != 0xFFFF) {
    *lower_exp = 0xFFFF;
    foundationBank(++pages, crubase);
  }
  foundationBank(0, crubase);
  return pages;
}

void crubit(int cru, int onoff) {
  __asm__(
    "MOV %0,r12\n\t"
    : : "r" (cru) : "r12"
  );

  if (onoff) {
    __asm__(
      "SBO 0\n\t"
    );
  } else {
    __asm__(
      "SBZ 0\n\t"
    );
  }
}
# 219 "main.c"
int __attribute__((noinline)) bank2cru(int page, int crubase) {
  unsigned char crus[8] = { 0x04, 0x0C, 0x14, 0x1C, 0x24, 0x2C, 0x34, 0x3C };
  return crubase + crus[page%8];
}

void __attribute__((noinline)) corcompBank(int page, int crubase) {
  int bank = page % 8;

  int bit = bank2cru(bank, crubase);

  crubit(crubase + 6, bank == page);

  int oldbank = bank == 0 ? 7 : bank - 1;
  int oldbit = bank2cru(oldbank, crubase);

  crubit(oldbit, 0);
  crubit(bit, 1);
}

int __attribute__((noinline)) hasCorcomp(int crubase) {

  volatile int* lower_exp = (volatile int*)0x2000;



  crubit(crubase + 2, 0);

  *lower_exp = 0xCCCC;
  if (*lower_exp == 0xCCCC) {
    return 0;
  }


  crubit(crubase + 2, 1);

  corcompBank(0, crubase);
  *lower_exp = 0x1234;
  corcompBank(1, crubase);
  *lower_exp = 0;
  corcompBank(0, crubase);
  if (*lower_exp == 0x1234) {
    corcompCru = crubase;
    return 1;
  } else {
    corcompCru = 0;
    return 0;
  }
}

int __attribute__((noinline)) corcompPagecount() {
  volatile int* lower_exp = (volatile int*)0x2000;
  for (int i = 0; i < 16; i++) {
    corcompBank(i, corcompCru);
    *lower_exp = 0x1234;
  }
  corcompBank(0, corcompCru);
  int pages = 0;
  while (pages < 16 && *lower_exp != 0xFFFF) {
    *lower_exp = 0xFFFF;
    corcompBank(++pages, corcompCru);
  }
  corcompBank(0, corcompCru);
  return pages;
}

void __attribute__ ((noinline)) samsMapOn() {
  __asm__(
    "LI r12, >1E00\n\t"
    "SBO 1\n\t"
  );
}

void __attribute__ ((noinline)) samsMapOff() {
  __asm__(
    "LI r12, >1E00\n\t"
    "SBZ 1\n\t"
  );
}

void __attribute__ ((noinline)) samsMapPage(int page, int location) {
  __asm__(
      "LI r12, >1E00\n\t"
      "SRL %0, 12\n\t"
      "SLA %0, 1\n\t"
      "SWPB %1\n\t"
      "SBO 0\n\t"
      "MOV %1, @>4000(%0)\n\t"
      "SBZ 0\n\t"
      "SWPB %1\n\t"
      :
      : "r"(location), "r"(page)
      : "r12");
}

int __attribute__ ((noinline)) hasSams() {
  volatile int* lower_exp = (volatile int*) 0x2000;
  samsMapOn();
  samsMapPage(0, 0x2000);
  *lower_exp = 0x1234;
  samsMapPage(1, 0x2000);
  *lower_exp = 0;
  samsMapPage(0, 0x2000);
  int detected = (*lower_exp == 0x1234);
  samsMapOff();
  return detected;
}

int __attribute__ ((noinline)) samsPagecount() {
  samsMapOn();
  volatile int* lower_exp = (volatile int*) 0x2000;


  for(int i = 0; i < 4096; i++) {
    samsMapPage(i, 0x2000);
    *lower_exp = 0x1234;
  }

  samsMapPage(0, 0x2000);
  int pages = 0;
  while(pages < 4096 && *lower_exp != 0xFFFF) {
    *lower_exp = 0xFFFF;
    samsMapPage(++pages, 0x2000);
  }
  samsMapOff();
  return pages;
}

int __attribute__ ((noinline)) test32k() {
  int ec = testBlock(6, (unsigned char*)0x2000);
  ec += testBlock(7, (unsigned char*)0xA000);
  ec += testBlock(8, (unsigned char*)0xC000);
  ec += testBlock(9, (unsigned char*)0xE000);
  return ec;
}

int __attribute__ ((noinline)) testFoundation(int pagecount, int crubase) {
  writestring(2, 20, int2str(32*pagecount));
  writestring(2, 23, "K");
  int ec = 0;
  for (int j = 0; j < pagecount && ec == 0; j++) {
    foundationBank(j, crubase);
    writestring(4, 16, "page ");
    writestring(4,21, int2str(j));
    ec += testBlock(6, (unsigned char*)0x2000);
    ec += testBlock(7, (unsigned char*)0xA000);
    ec += testBlock(8, (unsigned char*)0xC000);
    ec += testBlock(9, (unsigned char*)0xE000);
  }
  return ec;
}

int __attribute__((noinline)) testCorcomp(int pagecount) {
  writestring(2, 20, int2str(32 * pagecount));
  writestring(2, 23, "K");
  int ec = 0;
  for (int j = 0; j < pagecount && ec == 0; j++) {
    corcompBank(j, corcompCru);
    writestring(4, 16, "page ");
    writestring(4, 21, int2str(j));
    ec += testBlock(6, (unsigned char*)0x2000);
    ec += testBlock(7, (unsigned char*)0xA000);
    ec += testBlock(8, (unsigned char*)0xC000);
    ec += testBlock(9, (unsigned char*)0xE000);
  }
  return ec;
}

int __attribute__ ((noinline)) testSams(int pagecount) {
  writestring(2, 16, int2str(4*pagecount));
  writestring(2, 21, "K");
  int ec = 0;
  for (int j = 0; j < pagecount && ec == 0; j += 8 ) {
    samsMapOn();
    samsMapPage(j, 0x2000);
    samsMapPage(j+1, 0x3000);
    samsMapPage(j+2, 0xA000);
    samsMapPage(j+3, 0xB000);
    samsMapPage(j+4, 0xC000);
    samsMapPage(j+5, 0xD000);
    samsMapPage(j+6, 0xE000);
    samsMapPage(j+7, 0xF000);
    samsMapOff();
    writestring(4, 16, "pages            ");
    writestring(4,22, int2str(j));
    writestring(4,26, "->");
    writestring(4,29, int2str(j+7));
    ec += testBlock(6, (unsigned char*)0x2000);
    ec += testBlock(7, (unsigned char*)0xA000);
    ec += testBlock(8, (unsigned char*)0xC000);
    ec += testBlock(9, (unsigned char*)0xE000);

  }
  return ec;
}
# 421 "main.c"
void main(int passcount)
{
  set_text();
  VDP_SET_REGISTER(0x07, mcolor);
  vdpmemset(0x0000,' ',nTextEnd);
  charsetlc();

  char* ver = "2.2";

  try_limit = 12;
  if (passcount == 0)
  {
    try_limit = 1;
    passcount = 1;
    writestring(0, 0, "Memory Quick Check ver ");
    writestring(0, 23, ver);
  } else {
    writestring(0, 0, "Expansion Memory Test ver ");
    writestring(0, 26, ver);
  }

  writestring(23, 0, "- Jedimatt42/Atariage : matt@cwfk.net -");

  int memtype = 0;

  if (!hasRam()) {
    writestring(2, 0, "No RAM detected");
    while(1) { }
  } else if (hasSams() && samsPagecount() > (128 / 4)) {
    writestring(2, 0, "SAMS detected");
    memtype = 2;
  } else if (hasCorcomp(0x1000) || hasCorcomp(0x1400)) {
    writestring(2, 0, "Corcomp 256k/512k");
    memtype = 5;
  } else if (hasFoundation(0x1000)) {
    writestring(2, 0, "Myarc detected");
    memtype = 3;
  } else if (hasFoundation(0x1E00)) {
    writestring(2, 0, "Foundation detected");
    memtype = 1;
  } else {
    writestring(2, 0, "Standard 32K detected");
    memtype = 4;
  }

  if (passcount > 1) {
    writestring(4, 0, "Burnin");
    writestring(4, 7, "Pass ");
  }

  int pagecount = 0;

  if (memtype == 2) {
    pagecount = samsPagecount();
  } else if (memtype == 3) {
    pagecount = foundationPagecount(0x1000);
  } else if (memtype == 1) {
    pagecount = foundationPagecount(0x1E00);
  } else if (memtype == 5) {
    pagecount = corcompPagecount();
  }

  int ec = 0;
  for( int i = 1; i <= passcount && ec == 0; i++ ) {
    if (passcount > 1) {
      writestring(4, 12, int2str(i));
    }
    switch(memtype) {
      case 4:
        ec += test32k();
        break;
      case 2:
        ec += testSams(pagecount);
        break;
      case 3:
        ec += testFoundation(pagecount, 0x1000);
        break;
      case 1:
        ec += testFoundation(pagecount, 0x1E00);
        break;
      case 5:
        ec += testCorcomp(pagecount);
        break;
    }
  }
  printSummary(ec);

  while(1) { }
}
