/* this program converts a file into a TI binary format */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

// binary file state data
typedef struct {
   int pos;                           // file pointer
   int len;                           // length of the data in the file
   short last_block;                  // last block used in the file
   short is_executable;               // indicates whether the file is executable
   char fill[255 - 4 - 4 - 2 - 2];
} binary_state_t;

int to_big4 (int k) {
   char *ps = (char *) &k;
   int r;
   char *pt = (char *) &r + 3;
   int i;
   for (i = 0; i < 4; i++) {
      *pt = *ps;
      ps++;
      pt--;
   }

   return r;
}

short to_big2 (short k) {
   char *ps = (char *) &k;
   short r;
   char *pt = (char *) &r + 1;

   int i;
   for (i = 0; i < 2; i++) {
      *pt = *ps;
      ps++;
      pt--;
   }

   return r;
}

int main (int argc, char *argv[]) {

   FILE *fin, *fout;
   binary_state_t bs;
   int r, len;
   char *p;
   char *q;

   int is_executable = -1;

   if (strstr (argv[1], "-no_exec")) {
      is_executable = 0;
   } else if (strstr (argv[1], "-exec")) {
      is_executable = 1;
   } else {
      assert (0);
   }

   fin = fopen (argv[2], "r");
   assert (fin);

   bs.pos = to_big4 (0);
   r = fseek (fin, 0, SEEK_END);
   assert (!r);

   len = ftell (fin);
   assert (len >= 0);
   bs.len = to_big4 (len);
   p = malloc (len);
   assert (p);
   q = memset (&bs.fill, 0, sizeof (bs.fill));
   assert (q == (char *) &bs.fill);

   bs.last_block = to_big2 ((len - 1) / 255 + 1);
   
   bs.is_executable = to_big2 (is_executable);

   r = fseek (fin, 0, SEEK_SET);
   assert (!r);

   r = fread (p, len, 1, fin);
   assert (r == 1);

   r = fclose (fin);
   assert (!r);

   fout = fopen (argv[3], "w");
   assert (fout);

   r = fwrite (&bs, sizeof (bs) - 1, 1, fout);
   assert (r == 1);

   r = fwrite (p, len, 1, fout);
   assert (r == 1);

   r = fclose (fout);
   assert (!r);

   return 0;
}
