#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

// #define UNIX99

#define TOKEN_TYPE_NUMBER    1
#define TOKEN_TYPE_KEYWORD   2
#define TOKEN_TYPE_VAR_STR   3
#define TOKEN_TYPE_VAR_INT   4
#define TOKEN_TYPE_VAR_LONG  5
#define TOKEN_TYPE_VAR_FLOAT 6

#define TOKEN_KEYWORD_PRINT 1
#define TOKEN_KEYWORD_FOR   2
#define TOKEN_KEYWORD_NEXT  3
#define TOKEN_KEYWORD_END   4

typedef struct {
   char s[80];
   int len;
   int line_num;
   int token_type;
   int token_index;
   int next_line_index;    // regular lines flowing to next line, loop true index, next line for end-if
   int false_line_index;   // for loop false index
   char pad[36];
} line_t;

#ifdef UNIX99
   #define FOPEN dylib.fopen
   #define FGETS dylib.fgets
   #define FPUTS dylib.fputs
   #define FCLOSE dylib.fclose
#endif

#ifndef UNIX99
// ======================== BEGIN SHMMGR LIB PROXIES ===========================

   #define FOPEN fopen
   #define FGETS fgets
   #define FPUTS fputs
   #define FCLOSE fclose
   
   typedef struct {
      int count;
   } shmmgr_t;
   
   int shmmgr_init (shmmgr_t *shmmgr, const char *name, int value_type_size) {
      shmmgr->count = 0;
      return 0;
   }
   
   int shmmgr_alloc (shmmgr_t *shmmgr) {
      int r = shmmgr->count;
      shmmgr->count++;
      return r;
   }
   
   void *shmmgr_map_and_return_ptr (shmmgr_t *shmmgr, int index) {
      static line_t entry[4096];
      return &entry[index];
   }
   
   void shmmgr_free (shmmgr_t *shmmgr, int index) {
   }
   
   void shmmgr_term (shmmgr_t *shmmgr) {
   }

   #define NULL_CHAR 0x00
   char *skip_whitespace (const char *str) {
      char *s = (char *) str;
      while ( isspace (*s) && (*s != NULL_CHAR) ) s++;
      return s;
   }

// ======================== END SHMMGR LIB PROXIES ===========================
#endif 

typedef struct {
   shmmgr_t shmmgr;
   int count;
} prog_t;

prog_t prog;

char *get_token (char *s, int *token_type, int *token_index) {
   char token[32];
   char *t = token;

   while (*s) {
      if (*s == ' ') {
         while (*s == ' ') {
            s++;
         }
         break;
      }
      *t = *s;
      t++;
      s++;
   } 
   *t = 0x00;

   int val = atoi (token);
   if (val) {
      *token_type = TOKEN_TYPE_NUMBER;
      *token_index = val;
   } else {
      *token_index = 0;
      if (!strcmp (token, "PRINT")) {
         *token_index = TOKEN_KEYWORD_PRINT;
      } else if (!strcmp (token, "FOR")) {
         *token_index = TOKEN_KEYWORD_FOR;
      } else if (!strcmp (token, "NEXT")) {
         *token_index = TOKEN_KEYWORD_NEXT;
      } else if (!strcmp (token, "END")) {
         *token_index = TOKEN_KEYWORD_END;
      } 

      if (*token_index) {
         *token_type = TOKEN_TYPE_KEYWORD;
      } else {
         if (strstr (token, "!")) {
            *token_type = TOKEN_TYPE_VAR_INT;
         } else if (strstr (token, "%")) {
            *token_type = TOKEN_TYPE_VAR_LONG;
         } else if (strstr (token, "#")) {
            *token_type = TOKEN_TYPE_VAR_FLOAT;
         } else if (strstr (token, "$")) {
            *token_type = TOKEN_TYPE_VAR_STR;
         } else {
            *token_type = TOKEN_TYPE_VAR_INT;
         }
      }
   }

// fprintf (stdout, "[%s][%d][%d]\n", token, *token_type, *token_index);

   return s;
}

void prog_init () {
   if (shmmgr_init                                    // initialize the shared memory manager
          (&prog.shmmgr, 
           "basic", 
           sizeof (line_t))) {                                   
      FPUTS ("prog_init failed\n", stderr);
      exit (1);
   }
   prog.count = 0;
}

int prog_read (const char *name) {
   int r;
   line_t *v;
   int alloc_index;
   char s[128];
   int s_len;
   FILE *f;
   f = FOPEN (name, "r");
   if (f) {
      while (FGETS (s, sizeof (s), f)) {
         s[strcspn (s, "\r\n")] = 0x00;  // kill of CR and LF
         s_len = strlen (s);
         if (s_len) {
            alloc_index = shmmgr_alloc (&prog.shmmgr);
            v           = shmmgr_map_and_return_ptr (&prog.shmmgr, alloc_index);
            strcpy (v->s, s);
            v->len = strlen (s);
            prog.count++;
         }
      }
      FCLOSE (f);
      r = 0;
   } else {
      r = 1;
   }

   return r;
}

void prog_scan () {
   int i;
   line_t *v;
   char *s;
   int line_num, tt, ti;
   for (int i = 0; i < prog.count; i++) {
      v = shmmgr_map_and_return_ptr (&prog.shmmgr, i);
      FPUTS ("SCAN: ", stdout);
      FPUTS (v->s, stdout);
      FPUTS ("\n", stdout);
      s = skip_whitespace (v->s);
      s = get_token (s, &tt, &ti);

      line_num = 0;
      if (tt == TOKEN_TYPE_NUMBER) {
         line_num = ti;
         s = get_token (s, &tt, &ti);
      }
      v->line_num    = line_num;
      v->token_type  = tt;
      v->token_index = ti;

      fprintf (stdout, "SCAN: %d %d %d\n", v->line_num, v->token_type, v->token_index);
   }
}

int main (int argc, char *argv[]) {

   if (argc > 1) {
      int r = prog_read (argv[1]);
      if (!r) {
         prog_scan ();
      } else {
         FPUTS ("basic: could not open file ", stderr);
         FPUTS (argv[1], stderr);
         FPUTS ("\n", stderr);
      }
   } else {
      FPUTS ("basic: usage: basic filename\n", stderr);
   }

   return 0;
}
