#include <stdio.h>
#include <stdlib.h>
#include <basic.h>
#include <console.h>

void draw_all ();
void process_input ();
void meteor_generate ();
void handle_player_bullets ();
void move_all ();
void init_vals ();
void display_setup ();
void bmain ();

int restore_mode;
int restore_rows;
int restore_cols;

int level;

int player_ship_y;
int player_ship_x;
int player_ship_vy;
int player_ship_vx;

int player_bullet_y[4];
int player_bullet_x[4];
int player_bullet_vy[4];
int player_bullet_vx[4];
int player_bullet_index[4];
int player_bullet_inuse[4];

int enemy_ship_y;
int enemy_ship_x;
int enemy_ship_vy;
int enemy_ship_vy;
int enemy_ship_inuse;

int enemy_bullet_y;
int enemy_bullet_x;
int enemy_bullet_vy;
int enemy_bullet_vx;
int enemy_bullet_inuse;

int meteor_y[25];
int meteor_x[25];
int meteor_vy[25];
int meteor_vx[25];
int meteor_inuse[25];

void draw_all () {
   int i;
   int s;

   sprite (0, 16, 15, player_ship_y, player_ship_x, 0, 0);

   s = 1;
   for (i = 0; (1 > 0) ? (i <= 3) : (i >= 3); i += 1) {
      if (player_bullet_inuse[i] > 0) {
         sprite (s, player_bullet_index[i] , 15, player_bullet_y[i] , player_bullet_x[i] , 0, 0);
         player_bullet_index[i] = player_bullet_index[i] + 1;
         if (player_bullet_index[i] > 20) {
            player_bullet_index[i] = 17;
         }
      } else {
         sprite (s, 17, 15, 192, 0, 0, 0);
      }
      s = s + 1;
   }

   if (enemy_ship_inuse > 0) {
      sprite (5, 33, 15, player_ship_y, player_ship_x, 0, 0);
   }

   if (enemy_bullet_inuse > 0) {
      sprite (6, 33, 15, enemy_bullet_y, enemy_bullet_x, 0, 0);
   }

   s = 7;
   for (i = 0; (1 > 0) ? (i <= 24) : (i >= 24); i += 1) {
      if (meteor_inuse[i] > 0) {
         sprite (s, 24, 15, meteor_y[i] , meteor_x[i] , 0, 0);
      } else {
         sprite (s, 24, 15, 192, 0, 0, 0);
      }
      s = s + 1;
   }

}

void process_input () {
   int y;
   int x;

   joyst (0, &y, &x);

   player_ship_vy = player_ship_vy + y / 4;
   player_ship_vx = player_ship_vx + x / 4;

   if (player_ship_vy < -4) {
      player_ship_vy = -4;
   } else {
      if (player_ship_vy > 4) {
         player_ship_vy = 4;
      }
   }

   if (player_ship_vx < -4) {
      player_ship_vx = -4;
   } else {
      if (player_ship_vx > 4) {
         player_ship_vx = 4;
      }
   }

   if (inkey () == 90) {
      int i;
      for (i = 0; (1 > 0) ? (i <= 3) : (i >= 3); i += 1) {
         if (player_bullet_inuse[i] == 0) {
            player_bullet_y[i] = player_ship_y;
            player_bullet_x[i] = player_ship_x + 4;
            player_bullet_vy[i] = player_ship_vy;
            player_bullet_vx[i] = player_ship_vx + 4;
            player_bullet_index[i] = 17;
            player_bullet_inuse[i] = 1;
            break ;
         }
      }
   }

}

void meteor_generate () {

   if (rndi (192) < level) {
      int i;

      for (i = 0; (1 > 0) ? (i <= 24) : (i >= 24); i += 1) {
         if (meteor_inuse[i] == 0) {
            meteor_y[i] = rndi (192);
            meteor_x[i] = 255;
            meteor_vy[i] = 0;
            meteor_vx[i] = -1 - rndi (2);
            meteor_inuse[i] = 1;
            break ;
         }
      }
   }

}

void handle_player_bullets () {
   int i;
   int j;
   int sb;
   int sm;
   int did_coincide;

   sb = 1;
   for (i = 0; (1 > 0) ? (i <= 3) : (i >= 3); i += 1) {
      if (player_bullet_inuse[i] != 0) {
         sm = 7;
         for (j = 0; (1 > 0) ? (j <= 24) : (j >= 24); j += 1) {
            if (meteor_inuse[j] != 0) {
               coinc (sb, sm, 8, &did_coincide);
               if (did_coincide != 0) {
                  meteor_inuse[j] = 0;
                  player_bullet_inuse[i] = 0;
               }
            }
            sm = sm + 1;
         }
      }
      sb = sb + 1;
   }

}

void move_all () {
   player_ship_y = player_ship_y + player_ship_vy;
   player_ship_x = player_ship_x + player_ship_vx;

   if (player_ship_y < 0) {
      player_ship_y = 0;
      player_ship_vy = 0;
   } else {
      if (player_ship_y > 183) {
         player_ship_y = 183;
         player_ship_vy = 0;
      }
   }

   if (player_ship_x < 0) {
      player_ship_x = 0;
      player_ship_vx = 0;
   } else {
      if (player_ship_x > 80) {
         player_ship_x = 80;
         player_ship_vx = 0;
      }
   }

   int i;

   for (i = 0; (1 > 0) ? (i <= 3) : (i >= 3); i += 1) {
      if (player_bullet_inuse[i] > 0) {
         player_bullet_y[i] = player_bullet_y[i] + player_bullet_vy[i];
         player_bullet_x[i] = player_bullet_x[i] + player_bullet_vx[i];
         if (player_bullet_y[i] < 0) {
            player_bullet_inuse[i] = 0;
         } else {
            if (player_bullet_y[i] > 191) {
               player_bullet_inuse[i] = 0;
            }
         }
         if (player_bullet_x[i] > 255) {
            player_bullet_inuse[i] = 0;
         }
      }
   }

   for (i = 0; (1 > 0) ? (i <= 24) : (i >= 24); i += 1) {
      if (meteor_inuse[i] > 0) {
         meteor_y[i] = meteor_y[i] + meteor_vy[i];
         meteor_x[i] = meteor_x[i] + meteor_vx[i];
         if (meteor_y[i] < 0) {
            meteor_inuse[i] = 0;
         } else {
            if (meteor_y[i] > 191) {
               meteor_inuse[i] = 0;
            }
         }
         if (meteor_x[i] < 0) {
            meteor_inuse[i] = 0;
         }
      }
   }

}

void init_vals () {

   int i;

   player_ship_y = 92;
   player_ship_x = 40;
   player_ship_vy = 0;
   player_ship_vx = 0;
   for (i = 0; (1 > 0) ? (i <= 3) : (i >= 3); i += 1) {
      player_bullet_inuse[i] = 0;
   }

   enemy_ship_inuse = 0;
   enemy_bullet_inuse = 0;

   for (i = 0; (1 > 0) ? (i <= 24) : (i >= 24); i += 1) {
      meteor_inuse[i] = 0;
   }

}

void display_setup () {
   display_mode_get (&restore_mode);
   display_rows_and_cols (&restore_rows, &restore_cols);

   display_mode (0, 24);

   CHAR (16, string_assign ("E0703C7E7F3870E0"));
   CHAR (17, string_assign ("001010FE10100000"));
   CHAR (18, string_assign ("0204281028408000"));
   CHAR (19, string_assign ("1010103810101000"));
   CHAR (20, string_assign ("8040281028040200"));
   CHAR (24, string_assign ("1C1EFFFFFFFF7E3C"));
}

void bmain () {

   display_setup ();

   clear ();
   at (0, 0);
   string_print (stdout, string_assign ("Meteors!"));
   fprintf (stdout, "\n");
   atend ();

   level = 500;
   init_vals (level);

   while (1) {
      process_input ();
      meteor_generate ();
      handle_player_bullets ();
      move_all ();
      draw_all ();
   }

}

int main (int argc, char *argv[]) {

   pi = atof ("3.1415926535898");

   basic_files_init ();

   bmain ();

   return 0;
}
