/* bitmap_1.c
   This program demonstrates the use of console bitmap support.
   Usage: bitmap_1
   change log:
   12/31/2024 initial version
   01/11/2025 migrated initial bitmap implementation methods into the console package
   01/13/2025 removed mode from line drawing
              added more line drawing tests
   01/22/2025 performance improvements
   02/28/2025 updated for display rows
   06/05/2025 signal handling
   06/07/2025 updated to use use dylib
*/

// THE METHODS IN THIS FILE NEED TO BE ASSESSED FOR USEFULNESS AND MIGRATED INTO THE CONSOLE PACKAGE

#include <console.h>
#include <cache_private.h>
#include <vdp.h>
#include <stdlib.h>
#include <string.h>
#include <dylib.h>
#include <conversion.h>

void bitmap_demo_raw () {

   // clear the screen
   console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_INCREMENTING);

   // set the patterns
   unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   console_bitmap_set_all_patterns (char_pattern);

   // set the colors
   unsigned char color_pattern[] = {0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70};
   console_bitmap_set_all_colors (color_pattern);

   for (int i = 0; i < 94; i += 2) {
      console_bitmap_draw_line_right (0 + i, 0 + i, 256 - i * 2);
      console_bitmap_draw_line_right (191 - i, i, 256 - i * 2);
      console_bitmap_draw_line_down (i, i, 192 - i * 2);
      console_bitmap_draw_line_down (i, 255 - i, 192 - i * 2);
   }
 
   console_bitmap_draw_line (0, 0, 191, 255, CONSOLE_BITMAP_SET);
   console_bitmap_draw_line (0, 255, 191, 0, CONSOLE_BITMAP_SET);
   console_bitmap_draw_line (0, 0, 25, 50, CONSOLE_BITMAP_SET);
 
   unsigned char c = 0;
   unsigned char d = 0;
   int y;
   while (1) {
      vdpmemset (cachex.console.vdp_character_pattern_table + (12 * 32 + 16) * 8, c, 8);
      c++;
      for (y = 0; y < 192; y++) {
/*
         console_bitmap_draw_pixel (y, y, CONSOLE_BITMAP_SET);
         console_bitmap_set_pixel_color (y, y, d);
         console_bitmap_draw_pixel (y, 255 - y, CONSOLE_BITMAP_SET);
         console_bitmap_set_pixel_color (y, 255 - y, d);
*/
         console_bitmap_set_pixel_and_color (y, y, CONSOLE_BITMAP_SET, d += 0x10);
         console_bitmap_set_pixel_and_color (y, 255 - y, CONSOLE_BITMAP_SET, d += 0x10);
      }
      for (y = 0; y < 192; y++) {
/*
         console_bitmap_draw_pixel (y, y, CONSOLE_BITMAP_CLEAR);
         console_bitmap_set_pixel_color (y, y, d);
         console_bitmap_draw_pixel (y, 255 - y, CONSOLE_BITMAP_CLEAR);
         console_bitmap_set_pixel_color (y, 255 - y, d);
*/
         console_bitmap_set_pixel_and_color (y, y, CONSOLE_BITMAP_CLEAR, d += 0x10);
         console_bitmap_set_pixel_and_color (y, 255 - y, CONSOLE_BITMAP_CLEAR, d += 0x10);
      }

      d += 0x10;

      if (console_get_key () == '1') {
         break;
      };
   }
}

void bitmap_demo_complex () {

   // clear the screen
   console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_ZERO);

   // set the patterns
   unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   console_bitmap_set_all_patterns (char_pattern);

   // set the colors
   unsigned char color_pattern[] = {0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20};
   console_bitmap_set_all_colors (color_pattern);

   // d0       d2
   // _____XXX XXX_____
   // ___XX___ ___XX___
   // __X_____ _____X__
   // _X__XX__ __XX__X_
   // _X_X__X_ _X__X_X_
   // X__X__X_ _X__X__X
   // X__X__X_ _X__X__X
   // X___XX__ __XX___X

   // d1       d3
   // X_______ _______X
   // X_X_X___ ___X_X_X
   // X__X____ ____X__X
   // _X__X___ ___X__X_
   // _X___XX_ _XX___X_
   // __X____X X____X__
   // ___XX___ ___XX___
   // _____XXX XXX_____

   unsigned char d0[] = {0x07, 0x18, 0x20, 0x4c, 0x52, 0x92, 0x92, 0x8c};
   unsigned char d1[] = {0x80, 0xa8, 0x90, 0x48, 0x46, 0x21, 0x18, 0x07};
   unsigned char d2[] = {0xe0, 0x18, 0x04, 0x32, 0x4a, 0x49, 0x49, 0x31};
   unsigned char d3[] = {0x01, 0x15, 0x09, 0x12, 0x62, 0x84, 0x18, 0xe0};

   console_bitmap_set_pattern (0, 1, d0);
   console_bitmap_set_pattern (0, 2, d1);
   console_bitmap_set_pattern (0, 3, d2);
   console_bitmap_set_pattern (0, 4, d3);

   int row, col;
   for (row = 0; row < 8; row += 3) {
      for (col = 0; col < 32; col += 3) {
         console_bitmap_set_char (0, row, col, 1);
         console_bitmap_set_char (0, row + 1, col, 2);
         console_bitmap_set_char (0, row, col + 1, 3);
         console_bitmap_set_char (0, row + 1, col + 1, 4);
      }
   }

   unsigned char c0[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   unsigned char cs   = 0x20;
   unsigned char c;
   int j, k;

   while (1) {
      for (j = 1; j < 5; j++) {
         cs += 0x10;
         c   = cs;
         for (k = 0; k < 8; k++) {
            c0[k] = c;
            c     += 0x10;
         }
         console_bitmap_set_color_pattern (0, j, c0);
      }
      if (console_get_key () == '2') {
         break;
      }
   }
}

void bitmap_demo_lines () {

   // clear the screen
   console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_INCREMENTING);
   
   // set the patterns 
   unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   console_bitmap_set_all_patterns (char_pattern);
   
   // set the colors 
   unsigned char color_pattern[] = {0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70};
   console_bitmap_set_all_colors (color_pattern);

   // FAST
   for (int i = 0; i < 192; i++) {
      console_bitmap_draw_line_right (i, 0, 256);
      console_bitmap_clear_line_right (i, 0, 256);
   }

   // SLOW
   for (int i = 0; i < 192; i++) {
      console_bitmap_draw_line (i, 0, i, 255, 1);
      console_bitmap_draw_line (i, 0, i, 255, 0);
   }

   // MEDIUM
   for (int i = 0; i < 192; i++) {
      console_bitmap_draw_line2 (i, 0, i, 255);
      console_bitmap_clear_line (i, 0, i, 255);
   }

   // FAST
   for (int i = 0; i < 256; i++) {
      console_bitmap_draw_line_down (0, i, 192);
      console_bitmap_clear_line_down (0, i, 192);
   }

   // SLOW
   for (int i = 0; i < 256; i++) {
      console_bitmap_draw_line (0, i, 191, i, 1);
      console_bitmap_draw_line (0, i, 191, i, 0);
   }

   // MEDIUM
   for (int i = 0; i < 256; i++) {
      console_bitmap_draw_line2 (0, i, 191, i);
      console_bitmap_clear_line (0, i, 191, i);
   }

   char s[8];
   char *p;
   int len;
   int i;
   for (i = 32766; i >= 0; i -= 10) {
      p   = dylib.int2str (i);
      len = dylib.strlen (p);
      dylib.strcpy (s, "    ");
      dylib.strcpy (&s[5 - len], p);
      console_bitmap_write_text_raw (0, 0, s);
   }

}

int recover_display_mode;
int recover_display_rows;

void prog_exit () {
   // restore settings before exiting
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls ();
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   // save the current display mode
   console_display_get_mode (&recover_display_mode, &recover_display_rows);

   // switch to bitmap mode
   console_display_set_mode (DISPLAY_MODE_BITMAP, DISPLAY_ROWS_24);

   dylib.atexit (prog_exit);

   // demonstrate raw bitmap mode - most crude and most powerful
   bitmap_demo_raw ();

   bitmap_demo_complex ();

   bitmap_demo_lines ();

   return 0;
}

