/* bitmap_2.c
   This program demonstrates the use of console bitmap support.
   Usage: bitmap_2
   change log:
   01/13/2025 initial version
   02/28/2025 updated for remove of 80x30 mode
   05/07/2025 moved calls to dylib
   07/05/2025 dylib adjustments
*/

#include <console.h>
#include <stdlib.h>
#include <dylib.h>

void bitmap_demo_raw () {

   // clear the screen
   console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_INCREMENTING);

   // set the patterns
   unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   console_bitmap_set_all_patterns (char_pattern);

   // set the colors
   unsigned char color_pattern[] = {0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70};
   console_bitmap_set_all_colors (color_pattern);

   for (int x = 0; x < 256; x += 8) {
      console_bitmap_draw_line2 (96, 128, 0, x);
   }
   for (int y = 0; y < 192; y += 8) {
      console_bitmap_draw_line2 (96, 128, y, 255);
   }
   for (int x = 255; x >= 0; x -= 8) {
      console_bitmap_draw_line2 (96, 128, 191, x);
   }
   for (int y = 191; y >= 0; y -= 8) {
      console_bitmap_draw_line2 (96, 128, y, 0);
   }

   while (console_get_key () == 0xff);
}

int recover_display_mode;
int recover_display_rows;

// restore settings before exiting
void prog_term () {
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls ();
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   // save the current display mode
   console_display_get_mode (&recover_display_mode, &recover_display_rows);

   // switch to bitmap mode
   console_display_set_mode (DISPLAY_MODE_BITMAP, DISPLAY_ROWS_24);

   dylib.atexit (prog_term);

   // demonstrate raw bitmap mode - most crude and most powerful
   bitmap_demo_raw ();

   return 0;
}
