/* bitmap_3.c
   This program demonstrates drawing a set of raw images files.
   Usage: bitmap_3
   change log:
   01/25/2025 initial version
   01/26/2025 updated for console_bitmap_load/draw updates
   02/19/2025 updated usage description
   02/28/2025 updated for display rows
   05/03/2025 added dylib references
   06/05/2025 signal handling
   06/07/2025 moved calls to dylib
   09/22/2025 added test to confirm a positive number of bytes for the image were loaded
   10/05/2025 updated call to console_bitmap_load_image to pass a variable guaranteed to be in lower memory rather than uppper.
              The rom-based method for handing images maps pages into a000-ffff temparily, losing access to constants in the 
              program that undoubtedly are located at a000+.
*/

#include <stdlib.h>
#include <console.h>
#include <dylib.h>

// prints usage info
void print_usage () {
   dylib.fputs ("usage: bitmap_3 image\n", stderr);
} 

int recover_display_mode;
int recover_display_rows;

void reset_display () {
   files (3);

   // restore settings before exiting
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls ();
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   if (argc == 2) {

      const char *image_path = argv[1];

      // save the current display mode
      console_display_get_mode (&recover_display_mode, &recover_display_rows);

      // load the image while we have file access
      dylib.fputs ("loading images...", stdout);
      int bytes = console_bitmap_load_image (image_path, image_path);
      fprintf (stdout, "%d bytes, ", bytes);
      dylib.fputs ("done\n", stdout);

      if (bytes > 0) {

         char s[10];
         dylib.fgets (s, sizeof (s), stdin);

         files (0);

         // switch to bitmap mode
         console_display_set_mode (DISPLAY_MODE_BITMAP, DISPLAY_ROWS_24);

         // clear the screen
         console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_INCREMENTING);

         // set the patterns
         unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
         console_bitmap_set_all_patterns (char_pattern);
   
         // set the colors
         unsigned char color_pattern[] = {0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70};
         console_bitmap_set_all_colors (color_pattern);
   
         dylib.atexit (reset_display);
   
         // demonstrate raw bitmap mode
         console_bitmap_draw_image (image_path, 7, 7);
   
         console_getc ();
      }
 
   } else {
      print_usage ();
   }

   return 0;
}
