/* cat.c
   This program concatenates and prints files.
   Usage: cat [file [... filen]]
   change log:
   06/23/2023 initial version
   02/29/2024 updated to handle return values from cat and output errors
   12/25/2024 minor updates to code and usage statement
   01/20/2025 moved fputs to dylib
   06/08/2025 added getopt calls, reading of stdin
   06/16/2025 updated exit reference
*/ 

#include <util.h>
#include <stdio.h>
#include <dylib.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdlib.h>

void display_usage () {
   dylib.fputs ("usage: cat [file ...]\n", stderr);
}

int main (int argc, char *argv[]) {

  // capture the options
   int error = false;
   int opt;
   while ((opt = getopt (argc, argv, "")) != -1) {
      switch (opt) {
         case '?':                
         default:
            error = true;       
            break;         
      }
   }

   if (error) {
      display_usage ();
      exit (1);
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   int r;

   if (argc) {
      for (int i = 0; i < argc; i++) {
         r = cat (argv[i]);
         if (r) {
            dylib.fputs ("cat: ", stderr);
            dylib.fputs (argv[i], stderr);
            dylib.fputs (": No such file or directory\n", stderr);
         }
      }
   } else {
      r = cat_handle (stdin);
   }

   return 0;
}
