/* catb.c
   This program concatenates and prints files.
   Usage: catb [file [... filen]]
   change log:
   06/23/2023 initial version
   02/29/2024 updated to handle return values from cat and output errors
   03/08/2024 new version for binary files
   12/26/2024 updated usage statement
   01/20/2025 moved fputs to dylib
*/ 

#include <util.h>
#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   int r;

   for (int i = 1; i < argc; i++) {
      r = catb (argv[i]);
      if (r) {
         dylib.fputs ("catb: ", stderr);
         dylib.fputs (argv[i], stderr);
         dylib.fputs (": No such file or directory\n", stderr);
      }
   }

   return 0;
}
