/* cd.c
   This program changes the current working directory.
   Usage:
   cd [path]
   change log:
   08/05/2023 initial version
   08/20/2023 swapped use of fprintf with dylib.fputs to save memory
   11/03/2023 removed call to the unistd private API for writecwd
   11/13/2023 updated to change to the user's home directory when no parameter has been specified
   11/21/2023 updated to use FILENAME_MAX
   02/27/2024 added use of dylib
   01/20/2025 moved dylib to dylib
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <dylib.h>

const char *errmsg1 = "cd: ";
const char *errmsg2 = ": No such file or directory\n";

int main (int argc, char *argv[]) {

   // capture the cd path, whether specified or implied
   char path[FILENAME_MAX];
   if (argc >= 2) {
      dylib.strcpy (path, argv[1]);
   } else {
      dylib.strcpy (path, "~");
   }

   // attempt to change the directory
   int r = chdir (path);

   // handle an error if received
   if (r) {
      dylib.fputs (errmsg1, stderr);
      dylib.fputs (path, stderr);
      dylib.fputs (errmsg2, stderr);
   }

   return 0;
}
