/* chris.c 
   This program demonstrates the use of the image package.
   change log:
   11/16/2023 initial version
   12/10/2023 added reference to conversion.h
   03/01/2024 updated to use dylib
   01/17/2025 added call to image_init
   01/20/2025 updated fputs to dylib
   02/20/2025 corrected display logic that allowed for calling the display method even when the image generation had failed
*/

#include <stdio.h>
#include <image.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   const char *chris[] = {
      "---------------------XX-XX-------------------------",
      "--------------------X--X--X------------------------",
      "---------------------X---X-------------------------",
      "-XXXXX---X------------X-X--------------X-----------",
      "XX---XX--X-------------X---------------X-----------",
      "X--------X-----------------------------X-----------",
      "X--------X-XXX--X-XXX--X---XXXXX-------XXXXX---XXX-",
      "X--------XX---X-XX---X-X--X------------X----X-X---X",
      "X--------X----X-X------X---XXXX--------X----X-XXXXX",
      "XX----XX-X----X-X------X-X-----X-XX----X----X-X----",
      "-XXXXXX--X----X-X------X--XXXXX---X----XXXXX---XXX-",
      "---------------------------------------------------",
      "----------X----------------------------------------",
      "----------X----------------------------------------",
      "----------X----------------------------------------",
      "--XXXXX-XXXXX--X-XXX---XXXX--X-XXX---XXXX-------X--",
      "-X--------X----XX---X-X----X-XX---X-X----X------X--",
      "--XXXX----X----X------X----X-X----X-X----X----XXXXX",
      "X-----X---X--X-X------X----X-X----X-X----X------X--",
      "-XXXXX-----XX--X-------XXXX--X----X--XXXXX------X--",
      "-----------------------------------------X---------",
      "X------------------------------------XXXX------X---",
      "X----------------------------------------------X---",
      "X----------------------------------------------X---",
      "X-XXX--X-XXX---XXXX--X-----X--XXX--------------X---",
      "XX---X-XX---X------X-X-----X-X---X-------------X---",
      "X----X-X-------XXXXX--X---X--XXXXX-------------X---",
      "X----X-X------X----X---X-X---X-----------------X---",
      "-XXXX--X-------XXXXX----X-----XXX--------------X---",
      "---------------------------------------------------",
      "---------------------------------------------XX-XX-",
      "--------------------------------------------X--X--X",
      "-------------------------------------------- X---X-",
      "----------------------------------------------X-X--",
      "-----------------------------------------------X---",
      NULL
   };

   image_init ();

   image_t image_chris;
   int r;

   r = image_generate (&image_chris, chris);
   if (r) {
      dylib.fputs ("error generating chris message\n", stdout);
   } else {
      image_draw (&image_chris, 5, 1);
   }

   return 0;
}
