/* comp.c
   This method tests numeric type comparison.
   change log:
   11/22/2023 initial version
*/

#include <stdio.h>
#include <dylib.h>

void test (const char *n, int r) {
   dylib.fputs (n, stdout);
   dylib.fputs (": ", stdout);
   if (r) dylib.fputs ("pass\n", stdout); else dylib.fputs ("fail\n", stdout);
}

int main (int argc, char *argv[]) {

   test ("i > i", (int) 2 > (int) 1);
   test ("i >= i", (int) 2 >= (int) 1);
   test ("i < i", (int) 2 < (int) 3);
   test ("i <= i", (int) 2 <= (int) 3);
   test ("i == i", (int) 2 == (int) 2);

   test ("ui > ui", (unsigned int) 2 > (unsigned int) 1);
   test ("ui >= ui", (unsigned int) 2 >= (unsigned int) 1);
   test ("ui < ui", (unsigned int) 2 < (unsigned int) 3);
   test ("ui <= ui", (unsigned int) 2 <= (unsigned int) 3);
   test ("ui == ui", (unsigned int) 2 == (unsigned int) 2);

   test ("l > l", (long) 2 > (long) 1);
   test ("l >= l", (long) 2 >= (long) 1);
   test ("l < l", (long) 2 < (long) 3);
   test ("l <= l", (long) 2 <= (long) 3);
   test ("l == l", (long) 2 == (long) 2);

   test ("ul > ul", (unsigned long) 2 > (unsigned long) 1);
   test ("ul >= ul", (unsigned long) 2 >= (unsigned long) 1);
   test ("ul < ul", (unsigned long) 2 < (unsigned long) 3);
   test ("ul <= ul", (unsigned long) 2 <= (unsigned long) 3);
   test ("ul == ul", (unsigned long) 2 == (unsigned long) 2);

   test ("i == l", (int) 1 == (long) 1);
   test ("l == i", (long) 1 == (int) 1);

   return 0;
}
