typedef struct {
   int id;
   int reg[16];
   int page;
} proc_t;

typedef struct {
   int curr_index;
   int count;
   proc_t proc[16];
} procs_t;

procs_t procs;

void page_swap (int a, int b) {
}

void MEMSET (int a, int b, int c) {
}

void MEMCPY (int a, int b, int c) {
}

void lwpi (int a) {
}

void li (int a, int b) {
}

int sp = 0;
int sams_last_page = 255;

void perform_context_switch () {
   MEMSET (0x8320, 0x00, 16);                             // clear temp wp
   page_swap (0x3000, sams_last_page);                      // swap in the process info page
   lwpi (0x8320);                                           // set the workspace pointer
   li (sp, 0x4000);                                         // set the stack to top

   MEMCPY (0x8300, procs.proc[procs.curr_index].reg[0], 16);     // retain the current processes’ regs

   procs.curr_index++;                                       // move to the next process
   if (procs.curr_index == procs.count) {
      procs.curr_index = 0;
   }

   MEMCPY (procs.proc[procs.curr_index].reg[0], 0x8300, 16);     // get the next process’ regs

   page_swap (0xa000, procs.proc[procs.curr_index].page + 2); // swap in the next process’ ram pages
   page_swap (0xb000, procs.proc[procs.curr_index].page + 3);
   page_swap (0xc000, procs.proc[procs.curr_index].page + 4);
   page_swap (0xd000, procs.proc[procs.curr_index].page + 5);
   page_swap (0xe000, procs.proc[procs.curr_index].page + 6);
   page_swap (0xf000, procs.proc[procs.curr_index].page + 7);
   page_swap (0x2000, procs.proc[procs.curr_index].page);
   page_swap (0x3000, procs.proc[procs.curr_index].page + 1); // careful, we just swapped out this method’s info

   lwpi (0x8300);                                           // set the workspace pointer to the next process’ regs
                                                              // just return...all should be happy happy
}

int main (int argc, char *argv[]) {

   return 0;
}
