/* date.c
   This program implements the date program.
   limitations:
   - basic formats work but not all are implemented
   change log:
   05/02/2025 initial version
   06/13/2025 migrated time methods to libaries; added support for time from tipi and ide; major refactoring
   06/15/2025 added myarc support
   06/15/2025 updated exit references
   06/23/2025 added -m to the usage statement
*/

#include <dylib.h>
#include <time.h>
#include <time_private.h>
#include <unistd.h>
#include <stdlib.h>

void print_usage () {
   dylib.fputs ("usage: date [-a] [-i] [-m] [-t] [+<format>]\n", stderr);
}

int main (int argc, char *argv[]) {

   char format[80];
   char out[80];

   bool error          = false;                                  // error flag
   int mode = 0;

   // capture the options
   int opt;
   while ((opt = getopt (argc, argv, "aimt")) != -1) {
      switch (opt) {
         case 'a':                                               // handle the default color
            mode = 0;
            break;
         case 'i':
            mode = 1;
            break;
         case 'm':
            mode = 2;
            break;
         case 't':
            mode = 3;
            break;
         case '?':                                               // handle unknown options as errors
         default:
            error = true;
            break;
      }
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   if (error || argc > 1) {                              // exit if there was an error while processing options, no options
      print_usage ();                                            // were set or there are extra parameters
      exit (0);
   }

   dylib.strcpy (format, "+%a %b %d %H:%M:%S %Y");  // if no time format is specified, use this default
   if (argc == 1) {
      dylib.strcpy (format, argv[0]);                  // use the specified format in argv1
   }

   struct tm *mytime = NULL;

   switch (mode) {
      case 0:
         mytime = time_tm ();
         break;
      case 1:
         mytime = time_tm_ide ();
         break;
      case 2:
         mytime = time_tm_myarc ();
         break;
      case 3:
         mytime = time_tm_tipi ();
         break;
      default:
         break;
   }


   if (mytime) {
      int n = strftime (out, sizeof (out), format, mytime);
      if (n) {
         dylib.fputs (out, stdout);
         dylib.fputs ("\n", stdout);
      } else {
         dylib.fputs ("bad time format\n", stderr);
      }
   } else {
      dylib.fputs ("no clock\n", stderr);
   }

   return 0;
}
