/* diff.c
   This program compares two files.
   change log:
   06/12/2025 initial version
   06/16/2025 updated exit reference
   11/22/2025 updated to call compare_file
*/

#include <stdio.h>
#include <stdio_private.h>
#include <util.h>
#include <unistd.h>
#include <dylib.h>

void display_usage () {                                          // display usage information
   dylib.fputs ("usage: diff file1 file2\n", stderr);
}

int main (int argc, char *argv[]) {                              // the main procedure

   int r = 0;

   // capture the options
   int error = false;
   int opt;
   while ((opt = getopt (argc, argv, "")) != -1) {              // capture options
      switch (opt) {
         case '?':                                               // error/default case
         default:
            error = true;
            break;
      }
   }

   if (!error) {                                                 // process parameters

      argc -= optind;                                            // adjust argc and argv removing the processed options
      argv += optind;

      if (argc == 2) {                                           // handle file list
         r = compare_file (argv[0], argv[1]);                    // perform the compare
      } else {                                                   // handle missing file
         display_usage ();
      }
   } else {
      display_usage ();                                          // display usage
   }

   return r;                                                     // return a result 
}
