/* echo.c
   This program provides the echo utility.
   Usage: echo [-n] text
   Options:
   -n echo without terminating with a newline character
   change log:
   10/30/2023 initial version
   01/20/2025 moved fputs call to dylib
*/

#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <dylib.h>

void print_usage () {
   dylib.fputs ("usage: echo [-n] text\n", stdout);
}

int main (int argc, char *argv[]) {

   int r                   = 0;
   bool print_newline_char = true;
   bool error              = false;
  
   // capture the options
   int opt;
   while ((opt = getopt (argc, argv, "n")) != -1) {  // loop through all options
      switch (opt) {                                 // switch on an option
         case 'n':                                   // turn off the newline character writing
            print_newline_char = false;
            break;
         case '?':
         default:
            error = true;
            break;
      }
   }
 
   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   if (error) {
      print_usage ();
      r = 1;
   } else {
      for (int i = 0; i < argc; i++) {
         dylib.fputs (argv[i], stdout);
         if (i != argc - 1) {
            dylib.fputs (" ", stdout);
         }
      }
      if (print_newline_char) {
         dylib.fputs ("\n", stdout);
      }
   }

   return r;
}
