/* file_bin2.c
   This program tests binary file support.
   change log:
   12/22/2023 initial version
   12/29/2023 updated calls to fseek to calculate a seek address with long (had used integer)
   01/03/2024 misc updates after debugging
   02/24/2024 broad changes for cache and dylib
   03/01/2024 added use of dylib for f* methods
   01/10/2025 updated to use dylib.fwrite
   01/20/2025 updated fputs to dylib
              added removal of generated file
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <conversion.h>
#include <longdivmod.h>
#include <dylib.h>

#define COUNT 8

typedef struct {
   int v[COUNT];
} info_t;

void init_info (info_t *info, int v) {
   for (int i = 0; i < COUNT; i++) {
      info->v[i] = v;
   }
}

bool test_info (info_t *info, int v) {
   bool r = false;
   for (int i = 0; i < COUNT; i++) {
      r = info->v[i] != v;
      if (r) {
         dylib.fputs ("expected ", stdout);
         dylib.fputs (dylib.int2str (v), stdout);
         dylib.fputs (" found ", stdout);
         dylib.fputs (dylib.int2str (info->v[i]), stdout);
         dylib.fputs ("\n", stdout);
         break;
      }
   }
   return r;
}

int main (int argc, char *argv[]) {

#define FILENAME "binary"

   FILE *f;
   info_t info;
   int i, j, r;
   int nitems;
   long c = 0, k = 0;
   long spos;

   if (argc == 2) {
      nitems = atoi (argv[1]);
   } else {
      nitems = 128;
   }

   dylib.fputs ("test count = ", stdout);
   dylib.fputs (dylib.int2str (nitems), stdout);
   dylib.fputs (", size = ", stdout);
   dylib.fputs (dylib.int2str (sizeof (info_t)), stdout);
   dylib.fputs ("\n", stdout);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j += i) {
         c++;
      }
   }
   c *= 2;

   dylib.fputs ("writing\n", stdout);

   f = dylib.fopen (FILENAME, "wb");
   assert (f);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j += i) {

         dylib.fputs ("\r", stdout);
         dylib.fputs (ltoa (__divdi3 (k * (long) 100, c)), stdout);
         dylib.fputs ("%", stdout);
         k++;

         init_info (&info, j);
         spos = (long) j * (long) sizeof (info_t);

         r = dylib.fseek (f, spos, SEEK_SET);
         assert (r == 0);
         r = dylib.fwrite (&info, sizeof (info_t), 1, f);
         assert (r == 1);
      }
   }

   r = dylib.fclose (f);
   assert (!r);


   bool b;

   dylib.fputs ("\rreading\n", stdout);

   f = dylib.fopen (FILENAME, "rb");
   assert (f);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j+= i) {
         dylib.fputs ("\r", stdout);
         dylib.fputs (ltoa (__divdi3 (k * (long) 100, c)), stdout);
         dylib.fputs ("%", stdout);
         k++;

         init_info (&info, 0);
         spos = (long) j * (long) sizeof (info_t);
         r = dylib.fseek (f, spos, SEEK_SET);
         assert (r == 0);
         r = dylib.fread (&info, sizeof (info_t), 1, f);
         assert (r == 1);
         b = test_info (&info, j);
         if (b) break;
      }
   }

   r = dylib.fclose (f);
   assert (!r);

   r = remove (FILENAME);
   assert (!r);

   dylib.fputs ("\rdone\n", stdout);

   return 0;
}
