/* file_bl.c
   This program tests binary file support.
   change log:
   01/03/2023 initial version
   03/01/2024 added use of dylib
   01/10/2025 updated to use dylib.fwrite
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <conversion.h>
#include <longdivmod.h>
#include <dylib.h>

#define COUNT 128

typedef struct {
   long v[COUNT];
} info_t;

void init_info (info_t *info, long v) {
   for (int i = 0; i < COUNT; i++) {
      info->v[i] = v;
   }
}

bool test_info (info_t *info, int v) {
   bool r = false;
   for (int i = 0; i < COUNT; i++) {
      r = info->v[i] != v;
      if (r) {
         dylib.fputs ("expected ", stdout);
         dylib.fputs (ltoa (v), stdout);
         dylib.fputs (" found ", stdout);
         dylib.fputs (ltoa (info->v[i]), stdout);
         dylib.fputs ("\n", stdout);
         break;
      }
   }
   return r;
}

int main (int argc, char *argv[]) {

#define FILENAME "binary"

   FILE *f;
   info_t info;
   long i, j;
   int r;
   long nitems;
   long c = 0, k = 0;

   if (argc == 2) {
      nitems = atol (argv[1]);
   } else {
      nitems = 128;
   }

   dylib.fputs ("test count = ", stdout);
   dylib.fputs (ltoa (nitems), stdout);
   dylib.fputs (", size = ", stdout);
   dylib.fputs (dylib.int2str (sizeof (info_t)), stdout);
   dylib.fputs ("\n", stdout);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j += i) {
         c++;
      }
   }
   c *= 2;

   dylib.fputs ("writing\n", stdout);

   f = dylib.fopen (FILENAME, "wb");
   assert (f);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j += i) {

         dylib.fputs ("\r", stdout);
         dylib.fputs (ltoa (__divdi3 (k * (long) 100, c)), stdout);
         dylib.fputs ("%", stdout);
         k++;

         init_info (&info, j);
         r = dylib.fseek (f, j * (long) sizeof (info_t), SEEK_SET);
         assert (r == 0);
         r = dylib.fwrite (&info, sizeof (info_t), 1, f);
         assert (r == 1);
      }
   }

   r = dylib.fclose (f);
   assert (!r);


   bool b;

   dylib.fputs ("\rreading\n", stdout);

   f = dylib.fopen (FILENAME, "rb");
   assert (f);

   for (i = 32; i >= 1; i--) {
      for (j = 0; j < nitems; j+= i) {
         dylib.fputs ("\r", stdout);
         dylib.fputs (ltoa (__divdi3 (k * (long) 100, c)), stdout);
         dylib.fputs ("%", stdout);
         k++;

         init_info (&info, 0);
         r = dylib.fseek (f, j * (long) sizeof (info_t), SEEK_SET);
         assert (r == 0);
         r = dylib.fread (&info, sizeof (info_t), 1, f);
         assert (r == 1);
         b = test_info (&info, j);
         if (b) break;
      }
   }

   r = dylib.fclose (f);
   assert (!r);

   r = remove (FILENAME);
   assert (!r);

   dylib.fputs ("\rdone\n", stdout);

   return 0;
}
