/* file_bseq.c
   This program tests binary file support.
   change log:
   12/22/2023 initial version
   01/20/2025 updated fputs to dylib
              added removal of generated file
   06/11/2025 removed rs232 header reference
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdio_private.h>
#include <longdivmod.h>
#include <math.h>
#include <console.h>
#include <conversion.h>
#include <cache_private.h>
#include <dylib.h>
#include <vdp.h>
#include <errno.h>

int main (int argc, char *argv[]) {

#define FILENAME "binary"

   FILE *f;
   char s[14][80];

   dylib.fputs ("writing\n", stdout);

   assert ((f = dylib.fopen (FILENAME, "wb")));

   dylib.fputs ("John 1:1-10\n", f);
   dylib.fputs ("1 In the beginning was the Word, and the Word was with God, and the Word was\n", f);
   dylib.fputs ("God.\n", f);
   dylib.fputs ("2 The same was in the beginning with God.\n", f);
   dylib.fputs ("3 All things were made by him; and without him was not any thing made that was\n", f);
   dylib.fputs ("made.\n", f);
   dylib.fputs ("4 In him was life; and the life was the light of men.\n", f);
   dylib.fputs ("5 And the light shineth in darkness; and the darkness comprehended it not.\n", f);
   dylib.fputs ("6 # There was a man sent from God, whose name [was] John.\n", f);
   dylib.fputs ("7 The same came for a witness, to bear witness of the Light, that all [men]\n", f);
   dylib.fputs ("through him might believe.\n", f);
   dylib.fputs ("8 He was not that Light, but [was sent] to bear witness of that Light.\n", f);
   dylib.fputs ("9 [That] was the true Light, which lighteth every man that cometh into the\n", f);
   dylib.fputs ("world.\n", f);

   assert (dylib.fclose (f) == 0);


   dylib.fputs ("reading\n", stdout);

   assert ((f = dylib.fopen (FILENAME, "rb")));

   int n = 0;
   while (dylib.fgets (s[n], sizeof (s[n]), f)) {
      n++;
   }

   for (int i = 0; i < n; i++) {
      dylib.fputs (s[i], stdout);
   }

   assert (dylib.fclose (f) == 0);

   assert (remove (FILENAME) == 0);

   return 0;
}
