/* file_k.c
   This program tests binary file support.
   change log:
   12/22/2023 initial version
   01/20/2025 added removal of generated file
*/

#include <stdio.h>
#include <stdbool.h>
#include <assert.h>
#include <dylib.h>

#define REC_COUNT 16384
#define D_COUNT 127

typedef struct {
   int d[D_COUNT];
   char c;
} d_t;

int main (int argc, char *argv[]) {

#define FILENAME "b2"

   FILE *f;
   d_t d;
   int i, j, r;
   bool failed = false;

   fprintf (stdout, "writing\n");

   f = dylib.fopen (FILENAME, "wb");
   assert (f);

   for (i = 0; i < REC_COUNT; i++) {
      for (j = 0; j < D_COUNT; j++) {
         d.d[j] = i;
      }
      d.c = 'X';
  
      fprintf (stdout, "\r%d of %d", i, REC_COUNT);
      r = dylib.fwrite (&d, sizeof (d_t), 1, f);
      assert (r == 1);
   }

   fprintf (stdout, "\rdone          \n");

   r = dylib.fclose (f);
   assert (r == 0);


   fprintf (stdout, "reading\n");

   f = dylib.fopen (FILENAME, "rb");
   assert (f);

   for (i = 0; i < REC_COUNT; i++) {
      fprintf (stdout, "\r%d of %d", i, REC_COUNT);

      r = dylib.fread (&d, sizeof (d_t), 1, f);
      assert (r == 1);

      for (j = 0; j < D_COUNT; j++) {
         if (d.d[j] != i) {
            fprintf (stdout, "failed at %d\n", i);
            failed = true;
            break;
         }
      }
      if (d.c != 'X') {
         fprintf (stdout, "failed at %d\n", i);
         failed = true;
      }

      if (failed) {
         break;
      }
   }

   fprintf (stdout, "\rdone          \n");

   r = dylib.fclose (f);
   assert (r == 0);

   r = remove (FILENAME);
   assert (!r);

   return 0;
}
