/* file_text.c
   This program tests file access with the stdio.h package.
   change log:
   11/22/2023 initial version
   11/23/2023 updated to assert the standard file no's
   12/10/2023 removed reference to string_ext.h
   03/01/2024 updated to use dylib
   01/20/2025 updated fputs to dylib
*/

#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   // filename
   const char *fname = "testf";

   // text to be written
   const char *text[] = {
      "In the beginning was the Word, and the Word was with God, and the Word was God.",
      "He was in the beginning with God.",
      "All things were created by Him. and without Him nothing was made that was made.",
      "In Him was life, and that Life was the light of man.",
      "And the Light shines in the darkess, but the darkness could not extinguish it.",
      "He was that true Light giving light to every man coming into the world.",
      "He was in the world, and he created the world, but the world didn't know Him."
      "He came to His own, but His own didn't receive Him.",
      "But to those that did receive Him, He gave the right to become children of God,",
      "even those who believe in His name, who were born not of blood, nor the will of",
      "the flesh, nor the will of man, but of God."
      "And the Word became flesh and dwelt among us, and we beheld His glory--",
      "the Glory of the only Begotten of the Father, full of grace and truth.",
      "And of His fullness we have all received, and grace for grace.",
      "For the law was given through Moses, but grace and truth came through Jesus",
      "Christ.",
      "No one has seen God at any time, but the only Begotten Son, who is in the",
      "bossom of the Father, He has declared Him.",
      NULL
   };

   FILE *f;                                         // file handle
   char s[128];                                     // string buffer
   int i;                                           // text string index

   dylib.fputs ("file write/read test...", stdout); // write test name

   assert ((f = dylib.fopen (fname, "w")));         // open the file for writing
   i = 0;
   while (text[i]) {                                // loop through all the text
      assert (!dylib.fputs (text[i], f));           // write the text to the file
      assert (!dylib.fputs ("\n", f));              // write a line feed
      i++;                                          // move to the next line of text
   }
   assert (!dylib.fclose (f));                      // close the file

   assert ((f = dylib.fopen (fname, "r")));         // open the file for reading
   i = 0;
   while (dylib.fgets (s, sizeof (s), f)) {         // read all lines from the file
      s[dylib.strcspn (s, "\r\n")] = 0x00;          // remove the line feed
      assert (!dylib.strcmp (s, text[i]));          // compare the read text to the written text
      assert (!feof (f));                           // test for EOF
      i++;                                          // move to the next line of text
   }
   assert (feof (f));                               // test for EOF
   assert (!dylib.fclose (f));                      // close the file

   assert (!remove (fname));                        // remove the file

   assert (fileno (stdin) == STDIN_FILENO);         // test stdin fileno
   assert (fileno (stdout) == STDOUT_FILENO);       // test stdout fileno
   assert (fileno (stderr) == STDERR_FILENO);       // test stderr fileno

   dylib.fputs ("done\n", stdout);                  // write done message

   return 0;                                        // return result
}
