/* files.c
   This program demonstrates file management supports up to three files.
   Usage: files
   change log:
   01/02/2025 initial version
   01/20/2025 added removal of generated files
*/

#include <stdlib.h>
#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {
   int n = 1;
   if (argc > 1) {
      n = atoi (argv[1]);
   }

   int i, j, last;
   char filename[32];
   FILE *f[32];
   last = n;
   for (i = 0; i < n; i++) {
      sprintf (filename, "file_%d", i);
      f[i] = dylib.fopen (filename, "w");
      if (!f[i]) {
         fprintf (stdout, "cannot open file %d named %s\n", i, filename);
         last = i;
         break;
      }
   }  

   for (i = 0; i < 10; i++) {
      for (j = 0; j < last; j++) {
         fprintf (f[j], "%d\n", i);
      }
   }

   for (i = 0; i < last; i++) {
      dylib.fclose (f[i]);
      sprintf (filename, "file_%d", i);
      remove (filename);
   }

   return 0;
}
