/* free.c
   This program shows free memory.
   change log:
   01/04/2025 initial version
   01/12/2025 updated sams exists to sams page count
   01/18/2025 changed name to free
              updated output to better match unix free's output
   01/24/2025 set the minimum sams_free to 32KB since the cache will flush older items
   01/25/2025 added display of page id and filename in use
   02/08/2025 updated rom size to 32KB
   04/10/2025 added sram status
   06/25/2025 updated the output format to allow for larger values
   07/05/2025 corrected SAMS paging algorithms
   07/08/2025 added capability to print the named memory regions
   07/14/2025 added printing of cache ages
*/ 

#include <stdio.h>
#include <cache.h>
#include <unistd.h>
#include <stdlib.h>
#include <cache_private.h>
#include <dylib.h>

void print_usage () {
   dylib.fputs ("Usage: free [-p]\n", stderr);
}

int main (int argc, char *argv[]) {

   bool print_regions = false;
   bool error         = false;

   int opt;
   while ((opt = getopt (argc, argv, "p")) != -1) {
      switch (opt) {
         case 'p':                                               // handle printing memory regions
            print_regions = true;
            break;
         case '?':                                               // handle unknown options as errors
         default:
            error = true;       
            break;
      }
   }
   
   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   if (error || argc ) {                              // exit if there was an error while processing options, no options
      print_usage ();                                            // were set or there are extra parameters
      exit (1);
   }

   const long zero = 0;
   const long rom_size = (long) 8192 * (long) 4;
   const long ram_size = (long) 8192 * (long) 4;
   const long sams_size = (long) 4096 * (long) cache.sams.page_count;
   const long sams_used = (long) (((long) cache.sams.named_region_count + (long) 1) * (long) 6 + (long) 16) * (long) 4096;
   long sams_free = sams_size - sams_used;
   if (sams_free < (long) 4096 * (long) 8) {
      sams_free = (long) 4096 * (long) 8;
   }
   long sram_size;
   if (cachex.sram_is_expanded) {
      sram_size = 1024;
   } else {
      sram_size = 256;
   }

   fprintf (stdout, "%4s %8s %8s %8s\n", "", "total", "used", "free");
   fprintf (stdout, "%4s %8ld %8ld %8ld\n", "ROM", rom_size, rom_size, zero);
   fprintf (stdout, "%4s %8ld %8ld %8ld\n", "RAM", ram_size, zero, ram_size);
   fprintf (stdout, "%4s %8ld %8ld %8ld\n", "SAMS", sams_size, sams_used, sams_free);
   fprintf (stdout, "%4s %8ld %8ld %8ld\n", "SRAM", sram_size, sram_size, sram_size);

   if (print_regions) {
      int count = sams_get_region_count ();
      char name[FILENAME_MAX];
      int age;
      fprintf (stdout, "%-3s %-3s %s\n", "reg", "age", "name");
      for (int i = 0; i < count; i++) {
         sams_get_region_info (i, name, &age);
         fprintf (stdout, "%3d %3d %s\n", i, age, name);   
      }
   }

   return 0;
}
