#include "banks.h"
#define MYBANK BANK(3)

#include "vdp.h"
#include <b8_terminal.h>


const unsigned char TrueLowerCase[] = {				// chars 96-122
	 0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x04,0x3C,0x44,0x3C,0x00,
	 0x40,0x40,0x78,0x44,0x44,0x44,0x78,0x00,0x00,0x00,0x38,0x44,0x40,0x40,0x38,0x00,
	 0x04,0x04,0x3C,0x44,0x44,0x44,0x3C,0x00,0x00,0x00,0x38,0x44,0x7C,0x40,0x38,0x00,
	 0x0C,0x10,0x38,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x3C,0x44,0x44,0x3C,0x04,0x38,
	 0x40,0x40,0x78,0x44,0x44,0x44,0x44,0x00,0x10,0x00,0x10,0x10,0x10,0x10,0x38,0x00,
	 0x08,0x00,0x08,0x08,0x08,0x08,0x48,0x30,0x40,0x40,0x44,0x48,0x70,0x48,0x44,0x00,
	 0x30,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x68,0x54,0x54,0x54,0x54,0x00,
	 0x00,0x00,0x58,0x64,0x44,0x44,0x44,0x00,0x00,0x00,0x38,0x44,0x44,0x44,0x38,0x00,
	 0x00,0x00,0x78,0x44,0x44,0x44,0x78,0x40,0x00,0x00,0x3C,0x44,0x44,0x44,0x3C,0x04,
	 0x00,0x00,0x28,0x34,0x20,0x20,0x20,0x00,0x00,0x00,0x3C,0x40,0x38,0x04,0x78,0x00,
	 0x00,0x10,0x38,0x10,0x10,0x10,0x0C,0x00,0x00,0x00,0x44,0x44,0x44,0x4C,0x34,0x00,
	 0x00,0x00,0x44,0x44,0x44,0x28,0x10,0x00,0x00,0x00,0x54,0x54,0x54,0x54,0x28,0x00,
	 0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00,0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x38,
	 0x00,0x00,0x7C,0x08,0x10,0x20,0x7C,0x00,0x00,0x0C,0x10,0x10,0x20,0x10,0x10,0x0C,
	 0x00,0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x60,0x10,0x10,0x08,0x10,0x10,0x60,
	 0x00,0x00,0x20,0x54,0x08,0x00,0x00,0x00
};

static void st_vdpmemset(int pAddr, int ch, int cnt)
{
	VDP_SET_ADDRESS_WRITE(pAddr);
	while (cnt--)
	{
		VDPWD = ch;
	}
}

void charsetlc() {
	vdpmemcpy(gPattern+0x300, TrueLowerCase, sizeof(TrueLowerCase));
	bk_gplvdp(0x0018, gPattern+0x100-1, 64);	// the rest of the character set (-1 to shift it up to match lowercase)
	st_vdpmemset(gPattern+(30*8), 0xfc, 8);	// cursor
}


