# 1 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c"
# 1 "/Users/marko/Downloads/fcmd-2.5/banks.h" 1
# 2 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2


# 1 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/b2_dsrutil.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/libti99/files.h" 1
# 60 "/Users/marko/Downloads/fcmd-2.5/libti99/files.h"
struct __attribute__((__packed__)) PAB {
 unsigned char OpCode;
 unsigned char Status;
 unsigned int VDPBuffer;
 unsigned char RecordLength;
 unsigned char CharCount;
 unsigned int RecordNumber;
 unsigned char ScreenOffset;
 unsigned char NameLength;
 unsigned char *pName;
};




void files(unsigned char count);
# 88 "/Users/marko/Downloads/fcmd-2.5/libti99/files.h"
unsigned char dsrlnk(struct PAB *pab, unsigned int vdp);





void dsrlnkraw(unsigned int vdppab);
# 5 "/Users/marko/Downloads/fcmd-2.5/b2_dsrutil.h" 2
# 13 "/Users/marko/Downloads/fcmd-2.5/b2_dsrutil.h"
struct __attribute__((__packed__)) EntryLink {
  struct EntryLink* next;
  unsigned int* routine;
};

struct __attribute__((__packed__)) NameLink {
  struct NameLink* next;
  unsigned int routine;
  char name[8];
};

struct __attribute__((__packed__)) DeviceRomHeader {
  unsigned char flag;
  unsigned char version;
  unsigned int reserved1;
  struct EntryLink* powerlnk;
  struct NameLink* userlnk;
  struct NameLink* dsrlnk;
  struct NameLink* basiclnk;
  struct EntryLink* interruptlnk;
  unsigned int* gromsomething;
};


struct __attribute__((__packed__)) DeviceServiceRoutine {
  char name[8];
  int crubase;
  unsigned int addr;
  char unit;
};


extern struct DeviceServiceRoutine* dsrList;

struct __attribute__((__packed__)) DirEntry {
  char name[11];
  int type;
  int sectors;
  int reclen;
  char ts_hour;
  char ts_min;
  char ts_second;
  int ts_year;
  char ts_month;
  char ts_day;
};

struct __attribute__((__packed__)) VolInfo {
  char volname[11];
  int total;
  int available;
  char timestamps;
  struct DeviceServiceRoutine* dsr;
};

unsigned int dsr_open(struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int flags, int reclen);
unsigned int dsr_close(struct DeviceServiceRoutine* dsr, struct PAB* pab);
unsigned int dsr_read(struct DeviceServiceRoutine* dsr, struct PAB* pab, int recordNumber);
unsigned int dsr_write(struct DeviceServiceRoutine* dsr, struct PAB* pab, char* record, int reclen);
unsigned int dsr_status(struct DeviceServiceRoutine* dsr, struct PAB* pab);
unsigned int dsr_delete(struct DeviceServiceRoutine* dsr, struct PAB* pab);
unsigned int dsr_ea5load(struct DeviceServiceRoutine* dsr, const char* fname);
unsigned int dsr_reset(struct DeviceServiceRoutine* dsr, struct PAB* pab, int record);

unsigned int dsr_prg_load(struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int vdpaddr, int maxsize);
unsigned int dsr_prg_save(struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int vdpaddr, int count);

typedef void (*vol_entry_cb)(struct VolInfo*);
typedef void (*dir_entry_cb)(struct DirEntry*);

unsigned int loadDir(struct DeviceServiceRoutine* dsr, const char* pathname, vol_entry_cb vol_cb, dir_entry_cb dir_cb);
unsigned int existsDir(struct DeviceServiceRoutine* dsr, const char* pathname);
unsigned int existsFile(struct DeviceServiceRoutine* dsr, const char* pathname);

void loadDriveDSRs();

void enableROM(int crubase);
void disableROM(int crubase);

struct DeviceServiceRoutine* findDsr(char* devicename, int crubase);

void initPab(struct PAB* pab);

# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1






extern void* trampoline();
extern int trampdata;
# 97 "/Users/marko/Downloads/fcmd-2.5/b2_dsrutil.h" 2

static inline void bk_loadDriveDSRs () { static const int ab_loadDriveDSRs[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)loadDriveDSRs}; trampdata = (int)ab_loadDriveDSRs; trampoline (); }
static inline void bk_initPab (struct PAB* pab) { static const int ab_initPab[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)initPab}; trampdata = (int)ab_initPab; trampoline (pab); }
static inline void bk_enableROM (int crubase) { static const int ab_enableROM[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)enableROM}; trampdata = (int)ab_enableROM; trampoline (crubase); }
static inline void bk_disableROM (int crubase) { static const int ab_disableROM[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)disableROM}; trampdata = (int)ab_disableROM; trampoline (crubase); }

static inline struct DeviceServiceRoutine* bk_findDsr (char* devicename, int crubase) { static const int ab_findDsr[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)findDsr}; trampdata = (int)ab_findDsr; return (struct DeviceServiceRoutine*)trampoline (devicename, crubase); }
static inline unsigned int bk_existsDir (struct DeviceServiceRoutine* dsr, const char* pathname) { static const int ab_existsDir[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)existsDir}; trampdata = (int)ab_existsDir; return (unsigned int)trampoline (dsr, pathname); }
static inline unsigned int bk_existsFile (struct DeviceServiceRoutine* dsr, const char* pathname) { static const int ab_existsFile[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)existsFile}; trampdata = (int)ab_existsFile; return (unsigned int)trampoline (dsr, pathname); }
static inline unsigned int bk_dsr_delete (struct DeviceServiceRoutine* dsr, struct PAB* pab) { static const int ab_dsr_delete[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_delete}; trampdata = (int)ab_dsr_delete; return (unsigned int)trampoline (dsr, pab); }
static inline unsigned int bk_dsr_open (struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int flags, int reclen) { static const int ab_dsr_open[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_open}; trampdata = (int)ab_dsr_open; return (unsigned int)trampoline (dsr, pab, fname, flags, reclen); }
static inline unsigned int bk_dsr_close (struct DeviceServiceRoutine* dsr, struct PAB* pab) { static const int ab_dsr_close[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_close}; trampdata = (int)ab_dsr_close; return (unsigned int)trampoline (dsr, pab); }
static inline unsigned int bk_dsr_read (struct DeviceServiceRoutine* dsr, struct PAB* pab, int recordNumber) { static const int ab_dsr_read[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_read}; trampdata = (int)ab_dsr_read; return (unsigned int)trampoline (dsr, pab, recordNumber); }
static inline unsigned int bk_dsr_write (struct DeviceServiceRoutine* dsr, struct PAB* pab, char* record, int reclen) { static const int ab_dsr_write[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_write}; trampdata = (int)ab_dsr_write; return (unsigned int)trampoline (dsr, pab, record, reclen); }
static inline unsigned int bk_dsr_reset (struct DeviceServiceRoutine* dsr, struct PAB* pab, int record) { static const int ab_dsr_reset[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_reset}; trampdata = (int)ab_dsr_reset; return (unsigned int)trampoline (dsr, pab, record); }
static inline unsigned int bk_dsr_status (struct DeviceServiceRoutine* dsr, struct PAB* pab) { static const int ab_dsr_status[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_status}; trampdata = (int)ab_dsr_status; return (unsigned int)trampoline (dsr, pab); }
static inline unsigned int bk_dsr_ea5load (struct DeviceServiceRoutine * dsr, const char *fname) { static const int ab_dsr_ea5load[] = {(int)(0x6000|(9<<1)), (int)(0x6000|(10<<1)), (int)dsr_ea5load}; trampdata = (int)ab_dsr_ea5load; return (unsigned int)trampoline (dsr, fname); }
static inline unsigned int bk_loadDir (struct DeviceServiceRoutine* dsr, const char* pathname, vol_entry_cb vol_cb, dir_entry_cb dir_cb) { static const int ab_loadDir[] = {(int)(0x6000|(9<<1)), (int)(0x6000|(10<<1)), (int)loadDir}; trampdata = (int)ab_loadDir; return (unsigned int)trampoline (dsr, pathname, vol_cb, dir_cb); }

static inline unsigned int bk_dsr_prg_load (struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int vdpaddr, int maxsize) { static const int ab_dsr_prg_load[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_prg_load}; trampdata = (int)ab_dsr_prg_load; return (unsigned int)trampoline (dsr, pab, fname, vdpaddr, maxsize); }

static inline unsigned int bk_dsr_prg_save (struct DeviceServiceRoutine* dsr, struct PAB* pab, const char* fname, int vdpaddr, int count) { static const int ab_dsr_prg_save[] = {(int)(0x6000|(2<<1)), (int)(0x6000|(10<<1)), (int)dsr_prg_save}; trampdata = (int)ab_dsr_prg_save; return (unsigned int)trampoline (dsr, pab, fname, vdpaddr, count); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.h" 2





void handleCommand(char * buffer);
int must_close_command(char* buffer);

void parsePathParam(char* str_in, struct DeviceServiceRoutine** dsr, char* buffer, int requirements);
int globMatches(char* filename);



static inline void bk_handleCommand (char* buffer) { static const int ab_handleCommand[] = {(int)(0x6000|(10<<1)), (int)(0x6000|(10<<1)), (int)handleCommand}; trampdata = (int)ab_handleCommand; trampoline (buffer); }
static inline int bk_must_close_command (char* buffer) { static const int ab_must_close_command[] = {(int)(0x6000|(10<<1)), (int)(0x6000|(10<<1)), (int)must_close_command}; trampdata = (int)ab_must_close_command; return (int)trampoline (buffer); }
static inline void bk_parsePathParam (char* str_in, struct DeviceServiceRoutine** dsr, char* buffer, int requirements) { static const int ab_parsePathParam[] = {(int)(0x6000|(10<<1)), (int)(0x6000|(10<<1)), (int)parsePathParam}; trampdata = (int)ab_parsePathParam; trampoline (str_in, dsr, buffer, requirements); }
static inline int bk_globMatches (char* filename) { static const int ab_globMatches[] = {(int)(0x6000|(10<<1)), (int)(0x6000|(10<<1)), (int)globMatches}; trampdata = (int)ab_globMatches; return (int)trampoline (filename); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b0_main.h" 1






void cartmain();
void initGlobals();
void sleep(int jiffies);
void titleScreen();
void playtipi();
void checkBackspaceVar();

inline void reboot() {
  __asm__(
    "blwp @>0000"
  );
}
# 6 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b0_globals.h" 1





extern struct DeviceServiceRoutine* currentDsr;
extern struct DeviceServiceRoutine* scriptDsr;
extern struct PAB* scriptPab;
extern char currentPath[256];
extern char filterglob[12];
extern int backspace;
extern unsigned int displayWidth;
extern unsigned int displayHeight;
extern int scripton;
extern int pal;
extern int api_exec;
extern int request_break;
extern int* goto_line_ref;
# 7 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/commands.h" 1
# 10 "/Users/marko/Downloads/fcmd-2.5/commands.h"
void handleCls(); static inline void bk_handleCls () { static const int ab_handleCls[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleCls}; trampdata = (int)ab_handleCls; trampoline (); };
void handleExit(); static inline void bk_handleExit () { static const int ab_handleExit[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleExit}; trampdata = (int)ab_handleExit; trampoline (); };
void handleFg99(); static inline void bk_handleFg99 () { static const int ab_handleFg99[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleFg99}; trampdata = (int)ab_handleFg99; trampoline (); };
void handleLoad(); static inline void bk_handleLoad () { static const int ab_handleLoad[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleLoad}; trampdata = (int)ab_handleLoad; trampoline (); };
void handleTipiBeeps(); static inline void bk_handleTipiBeeps () { static const int ab_handleTipiBeeps[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleTipiBeeps}; trampdata = (int)ab_handleTipiBeeps; trampoline (); };
void handleVer(); static inline void bk_handleVer () { static const int ab_handleVer[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleVer}; trampdata = (int)ab_handleVer; trampoline (); };
void handleWidth(); static inline void bk_handleWidth () { static const int ab_handleWidth[] = {(int)(0x6000|(0<<1)), (int)(0x6000|(10<<1)), (int)handleWidth}; trampdata = (int)ab_handleWidth; trampoline (); };
void handleHistory(); static inline void bk_handleHistory () { static const int ab_handleHistory[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)handleHistory}; trampdata = (int)ab_handleHistory; trampoline (); };
void handleReadkey(); static inline void bk_handleReadkey () { static const int ab_handleReadkey[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)handleReadkey}; trampdata = (int)ab_handleReadkey; trampoline (); };
void handleBar(); static inline void bk_handleBar () { static const int ab_handleBar[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleBar}; trampdata = (int)ab_handleBar; trampoline (); };
void handleColor(); static inline void bk_handleColor () { static const int ab_handleColor[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleColor}; trampdata = (int)ab_handleColor; trampoline (); };
void handleLvl2(); static inline void bk_handleLvl2 () { static const int ab_handleLvl2[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleLvl2}; trampdata = (int)ab_handleLvl2; trampoline (); };
void handleMkdir(); static inline void bk_handleMkdir () { static const int ab_handleMkdir[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleMkdir}; trampdata = (int)ab_handleMkdir; trampoline (); };
void handleRename(); static inline void bk_handleRename () { static const int ab_handleRename[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleRename}; trampdata = (int)ab_handleRename; trampoline (); };
void handleRmdir(); static inline void bk_handleRmdir () { static const int ab_handleRmdir[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleRmdir}; trampdata = (int)ab_handleRmdir; trampoline (); };
void handleTipiHalt(); static inline void bk_handleTipiHalt () { static const int ab_handleTipiHalt[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleTipiHalt}; trampdata = (int)ab_handleTipiHalt; trampoline (); };
void handleTipiReboot(); static inline void bk_handleTipiReboot () { static const int ab_handleTipiReboot[] = {(int)(0x6000|(3<<1)), (int)(0x6000|(10<<1)), (int)handleTipiReboot}; trampdata = (int)ab_handleTipiReboot; trampoline (); };
void handleCd(); static inline void bk_handleCd () { static const int ab_handleCd[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleCd}; trampdata = (int)ab_handleCd; trampoline (); };
void handleChecksum(); static inline void bk_handleChecksum () { static const int ab_handleChecksum[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleChecksum}; trampdata = (int)ab_handleChecksum; trampoline (); };
void handleDrives(); static inline void bk_handleDrives () { static const int ab_handleDrives[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleDrives}; trampdata = (int)ab_handleDrives; trampoline (); };
void handleEcho(); static inline void bk_handleEcho () { static const int ab_handleEcho[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleEcho}; trampdata = (int)ab_handleEcho; trampoline (); };
void handleEnv(); static inline void bk_handleEnv () { static const int ab_handleEnv[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleEnv}; trampdata = (int)ab_handleEnv; trampoline (); };
void handleGoto(); static inline void bk_handleGoto () { static const int ab_handleGoto[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleGoto}; trampdata = (int)ab_handleGoto; trampoline (); };
void handleIf(); static inline void bk_handleIf () { static const int ab_handleIf[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleIf}; trampdata = (int)ab_handleIf; trampoline (); };
void handleProtect(); static inline void bk_handleProtect () { static const int ab_handleProtect[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleProtect}; trampdata = (int)ab_handleProtect; trampoline (); };
void handleType(); static inline void bk_handleType () { static const int ab_handleType[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleType}; trampdata = (int)ab_handleType; trampoline (); };
void handleUnprotect(); static inline void bk_handleUnprotect () { static const int ab_handleUnprotect[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)handleUnprotect}; trampdata = (int)ab_handleUnprotect; trampoline (); };
void handleDate(); static inline void bk_handleDate () { static const int ab_handleDate[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handleDate}; trampdata = (int)ab_handleDate; trampoline (); };
void handlePwd(); static inline void bk_handlePwd () { static const int ab_handlePwd[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handlePwd}; trampdata = (int)ab_handlePwd; trampoline (); };
void handleRDEmdk(); static inline void bk_handleRDEmdk () { static const int ab_handleRDEmdk[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handleRDEmdk}; trampdata = (int)ab_handleRDEmdk; trampoline (); };
void handleRDPart(); static inline void bk_handleRDPart () { static const int ab_handleRDPart[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handleRDPart}; trampdata = (int)ab_handleRDPart; trampoline (); };
void handleRDVol(); static inline void bk_handleRDVol () { static const int ab_handleRDVol[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handleRDVol}; trampdata = (int)ab_handleRDVol; trampoline (); };
void handleSysInfo(); static inline void bk_handleSysInfo () { static const int ab_handleSysInfo[] = {(int)(0x6000|(5<<1)), (int)(0x6000|(10<<1)), (int)handleSysInfo}; trampdata = (int)ab_handleSysInfo; trampoline (); };
void handleCFMount(); static inline void bk_handleCFMount () { static const int ab_handleCFMount[] = {(int)(0x6000|(6<<1)), (int)(0x6000|(10<<1)), (int)handleCFMount}; trampdata = (int)ab_handleCFMount; trampoline (); };
void handleTipimap(); static inline void bk_handleTipimap () { static const int ab_handleTipimap[] = {(int)(0x6000|(6<<1)), (int)(0x6000|(10<<1)), (int)handleTipimap}; trampdata = (int)ab_handleTipimap; trampoline (); };
void handleXb(); static inline void bk_handleXb () { static const int ab_handleXb[] = {(int)(0x6000|(6<<1)), (int)(0x6000|(10<<1)), (int)handleXb}; trampdata = (int)ab_handleXb; trampoline (); };
void handleFtp(); static inline void bk_handleFtp () { static const int ab_handleFtp[] = {(int)(0x6000|(7<<1)), (int)(0x6000|(10<<1)), (int)handleFtp}; trampdata = (int)ab_handleFtp; trampoline (); };
void handlePalette(); static inline void bk_handlePalette () { static const int ab_handlePalette[] = {(int)(0x6000|(7<<1)), (int)(0x6000|(10<<1)), (int)handlePalette}; trampdata = (int)ab_handlePalette; trampoline (); };
void handleCopy(); static inline void bk_handleCopy () { static const int ab_handleCopy[] = {(int)(0x6000|(9<<1)), (int)(0x6000|(10<<1)), (int)handleCopy}; trampdata = (int)ab_handleCopy; trampoline (); };
void handleDelete(); static inline void bk_handleDelete () { static const int ab_handleDelete[] = {(int)(0x6000|(9<<1)), (int)(0x6000|(10<<1)), (int)handleDelete}; trampdata = (int)ab_handleDelete; trampoline (); };
void handleDir(); static inline void bk_handleDir () { static const int ab_handleDir[] = {(int)(0x6000|(9<<1)), (int)(0x6000|(10<<1)), (int)handleDir}; trampdata = (int)ab_handleDir; trampoline (); };
void handleDebug(); static inline void bk_handleDebug () { static const int ab_handleDebug[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(10<<1)), (int)handleDebug}; trampdata = (int)ab_handleDebug; trampoline (); };
void handleEd(); static inline void bk_handleEd () { static const int ab_handleEd[] = {(int)(0x6000|(13<<1)), (int)(0x6000|(10<<1)), (int)handleEd}; trampdata = (int)ab_handleEd; trampoline (); };
void handleHelp(); static inline void bk_handleHelp () { static const int ab_handleHelp[] = {(int)(0x6000|(15<<1)), (int)(0x6000|(10<<1)), (int)handleHelp}; trampdata = (int)ab_handleHelp; trampoline (); };
# 8 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2

# 1 "/Users/marko/Downloads/fcmd-2.5/b1_strutil.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 1






# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1
# 8 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 2


int strlen(const char *s);



int atoi(char *s);


char *strcpy(char *d, const char *s);



int strcmp(const char *s1, const char *s2);



int memcmp(const void *s1, const void *s2, int n);


void *memcpy(void *dest, const void *src, int cnt);


void *memset(void *dest, int src, int cnt);



char *uint2str(unsigned int x);



char *int2str(int x);



char* uint2hex(unsigned int x);




void gets(char *buf, int maxlen);


static inline int bk_strlen (const char *s) { static const int ab_strlen[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strlen}; trampdata = (int)ab_strlen; return (int)trampoline (s); }
static inline int bk_atoi (char *s) { static const int ab_atoi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)atoi}; trampdata = (int)ab_atoi; return (int)trampoline (s); }
static inline char * bk_strcpy (char *d, const char *s) { static const int ab_strcpy[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strcpy}; trampdata = (int)ab_strcpy; return (char *)trampoline (d, s); }
static inline char * bk_uint2str (unsigned int x) { static const int ab_uint2str[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)uint2str}; trampdata = (int)ab_uint2str; return (char *)trampoline (x); }
static inline char * bk_uint2hex (unsigned int x) { static const int ab_uint2hex[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)uint2hex}; trampdata = (int)ab_uint2hex; return (char *)trampoline (x); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b1_strutil.h" 2


int strcmp(const char* a, const char* b);
int strcmpi(const char* a, const char* b);
int str_equals(char* a, char* b);
int indexof(const char* str, int c);
int lindexof(const char* str, int c, int start);
int str_startswith(const char* str, const char* prefix);
int str_endswith(const char* str, const char* suffix);
int basicToCstr(const char* str, char* buf);
char* strtok(char *str, int delim);
char* strtokpeek(char* str, int delim);
void strset(char* buffer, int value, int limit);
char* strcat(char* dst, const char* add);
char* strncpy(char* dest, char* src, int limit);
void strpad(char* dest, int limit, int pad);
int htoi(char* s);

extern char *lasts;

static inline void setstrtok(char *str)
{
    lasts = str;
}


extern char str2ram_buf[128];

static inline char* str2ram(const char* str) {
    memcpy(str2ram_buf, str, 128);
    return str2ram_buf;
}

static inline int bk_strcmp (const char *a, const char *b) { static const int ab_strcmp[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strcmp}; trampdata = (int)ab_strcmp; return (int)trampoline (a, b); }
static inline int bk_strcmpi (const char *a, const char *b) { static const int ab_strcmpi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strcmpi}; trampdata = (int)ab_strcmpi; return (int)trampoline (a, b); }
static inline int bk_str_equals (const char *a, const char *b) { static const int ab_str_equals[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)str_equals}; trampdata = (int)ab_str_equals; return (int)trampoline (a, b); }
static inline int bk_indexof (const char *str, int c) { static const int ab_indexof[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)indexof}; trampdata = (int)ab_indexof; return (int)trampoline (str, c); }
static inline int bk_lindexof (const char *str, int c, int start) { static const int ab_lindexof[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)lindexof}; trampdata = (int)ab_lindexof; return (int)trampoline (str, c, start); }
static inline int bk_str_startswith (const char *str, const char *prefix) { static const int ab_str_startswith[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)str_startswith}; trampdata = (int)ab_str_startswith; return (int)trampoline (str, prefix); }
static inline int bk_str_endswith (const char *str, const char *suffix) { static const int ab_str_endswith[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)str_endswith}; trampdata = (int)ab_str_endswith; return (int)trampoline (str, suffix); }
static inline int bk_basicToCstr (const char *str, char *buf) { static const int ab_basicToCstr[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)basicToCstr}; trampdata = (int)ab_basicToCstr; return (int)trampoline (str, buf); }
static inline char * bk_strtok (char *str, int delim) { static const int ab_strtok[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strtok}; trampdata = (int)ab_strtok; return (char *)trampoline (str, delim); }
static inline char * bk_strtokpeek (char *str, int delim) { static const int ab_strtokpeek[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strtokpeek}; trampdata = (int)ab_strtokpeek; return (char *)trampoline (str, delim); }
static inline void bk_strset (char *buffer, int value, int limit) { static const int ab_strset[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strset}; trampdata = (int)ab_strset; trampoline (buffer, value, limit); }
static inline char * bk_strcat (char *dst, const char *add) { static const int ab_strcat[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strcat}; trampdata = (int)ab_strcat; return (char *)trampoline (dst, add); }
static inline char * bk_strncpy (char *dest, char *src, int limit) { static const int ab_strncpy[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strncpy}; trampdata = (int)ab_strncpy; return (char *)trampoline (dest, src, limit); }
static inline void bk_strpad (char *dest, int limit, int pad) { static const int ab_strpad[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)strpad}; trampdata = (int)ab_strpad; trampoline (dest, limit, pad); }
static inline int bk_htoi (char* s) { static const int ab_htoi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(10<<1)), (int)htoi}; trampdata = (int)ab_htoi; return (int)trampoline (s); }
# 10 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b8_terminal.h" 1






unsigned int bgcolor(unsigned int color);
unsigned int textcolor(unsigned int color);
unsigned int bordercolor(unsigned int x);
unsigned int kscan(unsigned int mode);
void gplvdp(int vect, int adr, int cnt);
void vdp_setchar(int pAddr, int ch);
unsigned int conio_getvram();
void raw_cputc(int k);

typedef void (*identify_callback)(int flag);

void initTerminal();
void set_identify_hook(identify_callback cb);
identify_callback get_identify_hook();
void tputc(int c);
void tputs_ram(const char* str);
void cursorGoto(int x, int y);


static inline void bk_initTerminal () { static const int ab_initTerminal[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)initTerminal}; trampdata = (int)ab_initTerminal; trampoline (); }
static inline void bk_set_identify_hook (identify_callback cb) { static const int ab_set_identify_hook[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)set_identify_hook}; trampdata = (int)ab_set_identify_hook; trampoline (cb); }
static inline identify_callback bk_get_identify_hook () { static const int ab_get_identify_hook[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)get_identify_hook}; trampdata = (int)ab_get_identify_hook; return (identify_callback)trampoline (); }
static inline void bk_tputc (int c) { static const int ab_tputc[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)tputc}; trampdata = (int)ab_tputc; trampoline (c); }
static inline void bk_tputs_ram (const char* str) { static const int ab_tputs_ram[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)tputs_ram}; trampdata = (int)ab_tputs_ram; trampoline (str); }
static inline void bk_gplvdp (int vect, int adr, int cnt) { static const int ab_gplvdp[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)gplvdp}; trampdata = (int)ab_gplvdp; trampoline (vect, adr, cnt); }
static inline void bk_cursorGoto (int x, int y) { static const int ab_cursorGoto[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)cursorGoto}; trampdata = (int)ab_cursorGoto; trampoline (x, y); }

static inline unsigned int bk_bgcolor (unsigned int color) { static const int ab_bgcolor[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)bgcolor}; trampdata = (int)ab_bgcolor; return (unsigned int)trampoline (color); }
static inline unsigned int bk_textcolor (unsigned int color) { static const int ab_textcolor[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)textcolor}; trampdata = (int)ab_textcolor; return (unsigned int)trampoline (color); }
static inline unsigned int bk_bordercolor (unsigned int x) { static const int ab_bordercolor[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)bordercolor}; trampdata = (int)ab_bordercolor; return (unsigned int)trampoline (x); }
static inline unsigned int bk_kscan (unsigned int mode) { static const int ab_kscan[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)kscan}; trampdata = (int)ab_kscan; return (unsigned int)trampoline (mode); }
static inline void bk_vdp_setchar (int pAddr, int ch) { static const int ab_vdp_setchar[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)vdp_setchar}; trampdata = (int)ab_vdp_setchar; trampoline (pAddr, ch); }

static inline unsigned int bk_conio_getvram () { static const int ab_conio_getvram[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)conio_getvram}; trampdata = (int)ab_conio_getvram; return (unsigned int)trampoline (); }
static inline void bk_raw_cputc (int ch) { static const int ab_raw_cputc[] = {(int)(0x6000|(8<<1)), (int)(0x6000|(10<<1)), (int)raw_cputc}; trampdata = (int)ab_raw_cputc; trampoline (ch); }
# 11 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b4_labellist.h" 1





void labels_clear();
int labels_get(char* name);
void labels_add(char* name, int lineno);

static inline void bk_labels_clear () { static const int ab_labels_clear[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)labels_clear}; trampdata = (int)ab_labels_clear; trampoline (); }
static inline int bk_labels_get (char* name) { static const int ab_labels_get[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)labels_get}; trampdata = (int)ab_labels_get; return (int)trampoline (name); }
static inline void bk_labels_add (char* name, int lineno) { static const int ab_labels_add[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)labels_add}; trampdata = (int)ab_labels_add; trampoline (name, lineno); }
# 12 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b4_variables.h" 1
# 10 "/Users/marko/Downloads/fcmd-2.5/b4_variables.h"
char* vars_get(char* name);
void vars_set(char* name, char* value);
void printVars();

static inline char* bk_vars_get (char* name) { static const int ab_vars_get[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)vars_get}; trampdata = (int)ab_vars_get; return (char*)trampoline (name); }
static inline void bk_vars_set (char* name, char* value) { static const int ab_vars_set[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)vars_set}; trampdata = (int)ab_vars_set; trampoline (name, value); }
# 13 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b4_preprocess.h" 1






char* preprocess(char* buf);

static inline char* bk_preprocess (char* buf) { static const int ab_preprocess[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(10<<1)), (int)preprocess}; trampdata = (int)ab_preprocess; return (char*)trampoline (buf); }
# 14 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b11_handleExecutable.h" 1





void handleExecutable(char* ext);

char* token_cursor(char* dst, char* str, int delim);


static inline void bk_handleExecutable (char *ext) { static const int ab_handleExecutable[] = {(int)(0x6000|(11<<1)), (int)(0x6000|(10<<1)), (int)handleExecutable}; trampdata = (int)ab_handleExecutable; trampoline (ext); }
static inline char* bk_token_cursor (char* dst, char* str, int delim) { static const int ab_token_cursor[] = {(int)(0x6000|(11<<1)), (int)(0x6000|(10<<1)), (int)token_cursor}; trampdata = (int)ab_token_cursor; return (char*)trampoline (dst, str, delim); }
# 15 "/Users/marko/Downloads/fcmd-2.5/b10_parsing.c" 2






static int isAssignment(char* str) {
  int i = 0;
  while(str[i] != 0) {
    if (str[i] == '=') {
      return 1;
    }
    i++;
  }
  return 0;
}





int must_close_command(char* buffer) {
  if (isAssignment(buffer)) {
    return 0;
  }

  char* tok = bk_strtokpeek(buffer, ' ');
  if ((!(bk_strcmpi(tok,str2ram("bar"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("cls"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("cd"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("checksum"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("color"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("copy"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("date"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("delete"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("dir"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("drives"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("echo"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("env"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("goto"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("if"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("help"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("history"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("lvl2"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("mkdir"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("palette"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("protect"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("pwd"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("readkey"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("rename"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("rdemdk"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("rdpart"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("rdvol"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("rmdir"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("sysinfo"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("tipibeeps"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("type"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("unprotect"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("ver"))))) return 0;
  if ((!(bk_strcmpi(tok,str2ram("width"))))) return 0;
  return 1;
}



void handleCommand(char *buffer) {
  if (buffer[0] == 0) {
    return;
  }
  request_break = 0;


  char* procbuf = bk_preprocess(buffer);

  char* tok = bk_strtok(procbuf, ' ');
  if ((!(bk_strcmpi(tok,str2ram("bar"))))) bk_handleBar();
  else if ((!(bk_strcmpi(tok,str2ram("cls"))))) bk_handleCls();
  else if ((!(bk_strcmpi(tok,str2ram("cd"))))) bk_handleCd();
  else if ((!(bk_strcmpi(tok,str2ram("cfmount"))))) bk_handleCFMount();
  else if ((!(bk_strcmpi(tok,str2ram("checksum"))))) bk_handleChecksum();
  else if ((!(bk_strcmpi(tok,str2ram("color"))))) bk_handleColor();
  else if ((!(bk_strcmpi(tok,str2ram("copy"))))) bk_handleCopy();
  else if ((!(bk_strcmpi(tok,str2ram("date"))))) bk_handleDate();
  else if ((!(bk_strcmpi(tok,str2ram("debug"))))) bk_handleDebug();
  else if ((!(bk_strcmpi(tok,str2ram("delete"))))) bk_handleDelete();
  else if ((!(bk_strcmpi(tok,str2ram("dir"))))) bk_handleDir();
  else if ((!(bk_strcmpi(tok,str2ram("drives"))))) bk_handleDrives();
  else if ((!(bk_strcmpi(tok,str2ram("echo"))))) bk_handleEcho();
  else if ((!(bk_strcmpi(tok,str2ram("ed"))))) bk_handleEd();
  else if ((!(bk_strcmpi(tok,str2ram("env"))))) bk_handleEnv();
  else if ((!(bk_strcmpi(tok,str2ram("exit"))))) bk_handleExit();
  else if ((!(bk_strcmpi(tok,str2ram("fg99"))))) bk_handleFg99();
  else if ((!(bk_strcmpi(tok,str2ram("goto"))))) bk_handleGoto();
  else if ((!(bk_strcmpi(tok,str2ram("if"))))) bk_handleIf();
  else if ((!(bk_strcmpi(tok,str2ram("help"))))) bk_handleHelp();
  else if ((!(bk_strcmpi(tok,str2ram("history"))))) bk_handleHistory();
  else if ((!(bk_strcmpi(tok,str2ram("load"))))) bk_handleLoad();
  else if ((!(bk_strcmpi(tok,str2ram("lvl2"))))) bk_handleLvl2();
  else if ((!(bk_strcmpi(tok,str2ram("mkdir"))))) bk_handleMkdir();
  else if ((!(bk_strcmpi(tok,str2ram("palette"))))) bk_handlePalette();
  else if ((!(bk_strcmpi(tok,str2ram("protect"))))) bk_handleProtect();
  else if ((!(bk_strcmpi(tok,str2ram("pwd"))))) bk_handlePwd();
  else if ((!(bk_strcmpi(tok,str2ram("readkey"))))) bk_handleReadkey();
  else if ((!(bk_strcmpi(tok,str2ram("rename"))))) bk_handleRename();
  else if ((!(bk_strcmpi(tok,str2ram("rdemdk"))))) bk_handleRDEmdk();
  else if ((!(bk_strcmpi(tok,str2ram("rdpart"))))) bk_handleRDPart();
  else if ((!(bk_strcmpi(tok,str2ram("rdvol"))))) bk_handleRDVol();
  else if ((!(bk_strcmpi(tok,str2ram("rmdir"))))) bk_handleRmdir();
  else if ((!(bk_strcmpi(tok,str2ram("sysinfo"))))) bk_handleSysInfo();
  else if ((!(bk_strcmpi(tok,str2ram("tipibeeps"))))) bk_handleTipiBeeps();
  else if ((!(bk_strcmpi(tok,str2ram("tipihalt"))))) bk_handleTipiHalt();
  else if ((!(bk_strcmpi(tok,str2ram("tipimap"))))) bk_handleTipimap();
  else if ((!(bk_strcmpi(tok,str2ram("tipireboot"))))) bk_handleTipiReboot();
  else if ((!(bk_strcmpi(tok,str2ram("type"))))) bk_handleType();
  else if ((!(bk_strcmpi(tok,str2ram("unprotect"))))) bk_handleUnprotect();
  else if ((!(bk_strcmpi(tok,str2ram("ver"))))) bk_handleVer();
  else if ((!(bk_strcmpi(tok,str2ram("width"))))) bk_handleWidth();
  else if ((!(bk_strcmpi(tok,str2ram("xb"))))) bk_handleXb();
  else if (tok[bk_strlen(tok)-1] == ':') {
    if (scripton) {
      tok[bk_strlen(tok)-1] = 0;
      bk_labels_add(tok, *goto_line_ref);
    } else {
      bk_tputs_ram(str2ram("error, label only supported in script\n"));
    }
  } else if (isAssignment(buffer)) {
    char* name = bk_strtok(buffer, '=');
    char* value = bk_strtokpeek(0, 0);
    bk_vars_set(name, value);
  } else {
    if (tok) {
      bk_handleExecutable(tok);
    }
  }
}

int parsePath(char* path, char* devicename) {
  char workbuf[14];
  int crubase = 0;
  bk_strncpy(workbuf, path, 13);
  char* tok = bk_strtok(workbuf, '.');
  if (tok != 0 && tok[0] == '1' && bk_strlen(tok) == 4) {
    crubase = bk_htoi(tok);
    tok = bk_strtok(0, '.');
    bk_strncpy(devicename, tok, 8);
  } else {
    bk_strncpy(devicename, tok, 8);
  }
  return crubase;
}

void parsePathParam(char* str_in, struct DeviceServiceRoutine** dsr, char* buffer, int requirements) {
  filterglob[0] = 0;
  buffer[0] = 0;
  char *path = bk_strtok(str_in, ' ');
  *dsr = currentDsr;
  if (path == 0) {
    if (requirements & 0x0001) {
      *dsr = 0;
      return;
    }
    bk_strcpy(buffer, currentPath);
    return;
  } else {
    char devicename[8];
    if (0 == bk_strcmp(str2ram(".."), path)) {
      int ldot = bk_lindexof(currentPath, '.', bk_strlen(currentPath) - 2);
      if (ldot == -1) {
        *dsr = 0;
        bk_tputs_ram(str2ram("No parent folder\n"));
        return;
      }
      bk_strncpy(buffer, currentPath, ldot);
      return;
    } else {
      int crubase = parsePath(path, devicename);
      *dsr = bk_findDsr(devicename, crubase);
      if (*dsr == 0) {

        bk_strcpy(buffer, currentPath);
        bk_strcat(buffer, path);
        parsePath(buffer, devicename);
        *dsr = bk_findDsr(devicename, currentDsr->crubase);

        if (*dsr == 0) {
          bk_tputs_ram(str2ram("device not found.\n"));
          return;
        }

      }
      if (crubase != 0) {
        path = bk_strtok(path, '.');
        path = bk_strtok(0, ' ');
        bk_strcpy(buffer, path);
      } else {
        if (buffer[0] == 0) {
          bk_strcpy(buffer, path);
        }
      }
    }
  }

  if (requirements & 0x0002) {
    int len = bk_strlen(buffer);
    int dotidx = bk_lindexof(buffer, '.', len);

    bk_strcpy(filterglob, buffer+dotidx+1);
    buffer[dotidx] = 0;
  }
}


int globMatches(char* filename) {
  if (filterglob[0] == 0) {
    return 1;
  }

  int prelen = bk_indexof(filterglob, '*');
  if (prelen == -1) {
    return 0 == bk_strcmp(filename, filterglob);
  } else {
    char prefix[12];
    bk_strncpy(prefix, filterglob, prelen);

    char suffix[12];
    bk_strcpy(suffix, filterglob+prelen+1);

    return bk_str_startswith(filename, prefix) && bk_str_endswith(filename, suffix);
  }
}
