# 1 "/Users/marko/Downloads/fcmd-2.5/b12_speech.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "/Users/marko/Downloads/fcmd-2.5/b12_speech.c"
# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/banks.h" 1
# 5 "/Users/marko/Downloads/fcmd-2.5/banking.h" 2


extern void* trampoline();
extern int trampdata;
# 2 "/Users/marko/Downloads/fcmd-2.5/b12_speech.c" 2


# 1 "/Users/marko/Downloads/fcmd-2.5/b12_speech.h" 1
# 25 "/Users/marko/Downloads/fcmd-2.5/b12_speech.h"
struct __attribute__((__packed__)) LpcPlaybackCtx {
    char* addr;
    int remaining;
};






void speech_reset();





int detect_speech();





void say_vocab(int phrase_addr);




void say_data(const char* addr, int len);





void speech_start(struct LpcPlaybackCtx* ctx);




void speech_continue(struct LpcPlaybackCtx* ctx);




void speech_wait();


static inline void bk_speech_reset () { static const int ab_speech_reset[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)speech_reset}; trampdata = (int)ab_speech_reset; trampoline (); }
static inline int bk_detect_speech () { static const int ab_detect_speech[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)detect_speech}; trampdata = (int)ab_detect_speech; return (int)trampoline (); }
static inline void bk_say_vocab (int phrase_addr) { static const int ab_say_vocab[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)say_vocab}; trampdata = (int)ab_say_vocab; trampoline (phrase_addr); }
static inline void bk_say_data (const char* addr, int len) { static const int ab_say_data[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)say_data}; trampdata = (int)ab_say_data; trampoline (addr, len); }
static inline void bk_speech_start (struct LpcPlaybackCtx* ctx) { static const int ab_speech_start[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)speech_start}; trampdata = (int)ab_speech_start; trampoline (ctx); }
static inline void bk_speech_continue (struct LpcPlaybackCtx* ctx) { static const int ab_speech_continue[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)speech_continue}; trampdata = (int)ab_speech_continue; trampoline (ctx); }
static inline void bk_speech_wait () { static const int ab_speech_wait[] = {(int)(0x6000|(12<<1)), (int)(0x6000|(12<<1)), (int)speech_wait}; trampdata = (int)ab_speech_wait; trampoline (); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b12_speech.c" 2


typedef void (*read_func)();
# 18 "/Users/marko/Downloads/fcmd-2.5/b12_speech.c"
void safe_read() {
  __asm__(
    "MOVB @>9000,@%0\n\t"
    "NOP\n\t"
    "NOP\n\t"
    : : "i" (0x8320)
  );
}

void delay_asm_12() {
  __asm__(
    "NOP\n\t"
    "NOP"
  );
}

void delay_asm_42() {
  __asm__(
    "\tLI r12,10\n"
    "loop%=\n\t"
    "DEC r12\n\t"
    "JNE loop%="
    : : : "r12"
  );
}

void copy_safe_read() {
  int* source = (int*) safe_read;
  int* target = (int*) (0x8320 +2);
  int len = 12;
  while(len) {
    *target++ = *source++;
    len -= 2;
  }
}

unsigned char __attribute__((noinline)) call_safe_read() {
  ((read_func)(0x8320 +2))();
  return *((volatile unsigned char*)(0x8320));
}

void load_speech_addr(int phrase_addr) {
  *((volatile unsigned char*)0x9400) = 0x40 | (char)(phrase_addr & 0x000F);
  *((volatile unsigned char*)0x9400) = 0x40 | (char)((phrase_addr >> 4) & 0x000F);
  *((volatile unsigned char*)0x9400) = 0x40 | (char)((phrase_addr >> 8) & 0x000F);
  *((volatile unsigned char*)0x9400) = 0x40 | (char)((phrase_addr >> 12) & 0x000F);

  *((volatile unsigned char*)0x9400) = 0x40;
  delay_asm_42();
}

void say_vocab(int phrase_addr) {
  load_speech_addr(phrase_addr);
  *((volatile unsigned char*)0x9400) = 0x50;
  delay_asm_12();
}

void say_data(const char* addr, int len) {
  struct LpcPlaybackCtx ctx;
  ctx.addr = (char*) addr;
  ctx.remaining = len;

  speech_start(&ctx);
  while(ctx.remaining > 0) {

    __asm__(
      "clr r12\n\t"
      "tb 2\n\t"
      "jeq -4\n\t"
      "movb @>8802,r12"
      : : : "r12"
    );

    speech_continue(&ctx);
  }
}

void speech_start(struct LpcPlaybackCtx* ctx) {
  *((volatile unsigned char*)0x9400) = 0x60;
  delay_asm_12();

  int i = 16;
  while(i > 0 && ctx->remaining > 0) {
    *((volatile unsigned char*)0x9400) = *ctx->addr++;
    ctx->remaining--;
    i--;
  }
}

void speech_continue(struct LpcPlaybackCtx* ctx) {

  if (((int)call_safe_read()) & 0x40) {

    int i = 8;
    while (i > 0 && ctx->remaining > 0) {
      *((volatile unsigned char*)0x9400) = *ctx->addr++;
      ctx->remaining--;
      i--;
    }
  }
}

void speech_reset() {
  copy_safe_read();
  *((volatile unsigned char*)0x9400) = 0x70;
  ((read_func)(0x8320 +2))();
}

int detect_speech() {
  speech_reset();
  load_speech_addr(0);
  *((volatile unsigned char*)0x9400) = 0x10;
  delay_asm_12();
  ((read_func)(0x8320 +2))();
  return *((volatile unsigned char*)(0x8320)) == 0xAA;
}

void speech_wait() {
  delay_asm_42();
  delay_asm_12();
  *((volatile unsigned char*)(0x8320)) = 0x80;
  while (*((volatile unsigned char*)(0x8320)) & 0x80) {
    ((read_func)(0x8320 +2))();
  }
}
