# 1 "/Users/marko/Downloads/fcmd-2.5/b1_list.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "/Users/marko/Downloads/fcmd-2.5/b1_list.c"
# 1 "/Users/marko/Downloads/fcmd-2.5/banks.h" 1
# 2 "/Users/marko/Downloads/fcmd-2.5/b1_list.c" 2


# 1 "/Users/marko/Downloads/fcmd-2.5/b1_list.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1






extern void* trampoline();
extern int trampdata;
# 5 "/Users/marko/Downloads/fcmd-2.5/b1_list.h" 2

struct __attribute__((__packed__)) List {
    char* addr;
    char* end;
    char* ceiling;
};

struct __attribute__((__packed__)) ListEntry {
    int length;
    char data[];
};



void list_init(struct List* list, void* addr, void* ceiling);
void list_push(struct List* list, char* buffer, int length);
void list_pop(struct List* list, char* buffer, int limit);
struct ListEntry* list_get(struct List* list, int index);

static inline void bk_list_init (struct List* list, void* addr, void* ceiling) { static const int ab_list_init[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)list_init}; trampdata = (int)ab_list_init; trampoline (list, addr, ceiling); }
static inline void bk_list_push (struct List* list, char* buffer, int length) { static const int ab_list_push[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)list_push}; trampdata = (int)ab_list_push; trampoline (list, buffer, length); }
static inline void bk_list_pop (struct List* list, char* buffer, int limit) { static const int ab_list_pop[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)list_pop}; trampdata = (int)ab_list_pop; trampoline (list, buffer, limit); }
static inline struct ListEntry* bk_list_get (struct List* list, int index) { static const int ab_list_get[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)list_get}; trampdata = (int)ab_list_get; return (struct ListEntry*)trampoline (list, index); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b1_list.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 1






# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1
# 8 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 2


int strlen(const char *s);



int atoi(char *s);


char *strcpy(char *d, const char *s);



int strcmp(const char *s1, const char *s2);



int memcmp(const void *s1, const void *s2, int n);


void *memcpy(void *dest, const void *src, int cnt);


void *memset(void *dest, int src, int cnt);



char *uint2str(unsigned int x);



char *int2str(int x);



char* uint2hex(unsigned int x);




void gets(char *buf, int maxlen);


static inline int bk_strlen (const char *s) { static const int ab_strlen[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)strlen}; trampdata = (int)ab_strlen; return (int)trampoline (s); }
static inline int bk_atoi (char *s) { static const int ab_atoi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)atoi}; trampdata = (int)ab_atoi; return (int)trampoline (s); }
static inline char * bk_strcpy (char *d, const char *s) { static const int ab_strcpy[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)strcpy}; trampdata = (int)ab_strcpy; return (char *)trampoline (d, s); }
static inline char * bk_uint2str (unsigned int x) { static const int ab_uint2str[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)uint2str}; trampdata = (int)ab_uint2str; return (char *)trampoline (x); }
static inline char * bk_uint2hex (unsigned int x) { static const int ab_uint2hex[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(1<<1)), (int)uint2hex}; trampdata = (int)ab_uint2hex; return (char *)trampoline (x); }
# 6 "/Users/marko/Downloads/fcmd-2.5/b1_list.c" 2

void list_init(struct List* list, void* addr, void* ceiling) {
  list->addr = (char*)addr;
  list->end = (char*)addr;
  list->ceiling = (char*)ceiling;
}

void list_remove_first(struct List* list) {
  if (list->end > list->addr) {
    int remove_len = ((struct ListEntry*)(list->addr))->length + 2;
    char* src = list->addr + remove_len;
    memcpy(list->addr, src, list->end - src);
    list->end -= remove_len;
  }
}

char* list_find_last(struct List* list) {
  if (list->addr != list->end) {
    char* cursor = list->addr;
    while ((((struct ListEntry*)cursor)->length) + 2 < (int)list->end) {
      cursor += ((struct ListEntry*)cursor)->length + 2;
    }
    return cursor;
  } else {
    return 0;
  }
}

struct ListEntry* list_get(struct List* list, int index) {
  char* cursor = list->addr;
  while(index && (cursor < list->end)) {
    cursor += ((struct ListEntry*) cursor)->length + 2;
    index--;
  }
  if (cursor == list->end) {
    return 0;
  }
  if (!index) {
    return (struct ListEntry*)cursor;
  }
  return 0;
}

void list_push(struct List* list, char* buffer, int length) {

  while(list->ceiling - list->end < 2 + length) {
    char* last = list_find_last(list);
    list->end = last;
  }

  char* dst = list->end + length + 1;
  char* src = list->end - 1;
  int cnt = list->end - list->addr;
  while(cnt) {
    *dst-- = *src--;
    cnt--;
  }

  struct ListEntry* entry = (struct ListEntry*) list->addr;
  entry->length = length;
  memcpy(entry->data, buffer, length);
  list->end += length + 2;
}

void list_pop(struct List* list, char* buffer, int limit) {
  if (list->end > list->addr) {
    struct ListEntry* entry = (struct ListEntry*) list->addr;
    int cpylen = entry->length < limit ? entry->length : limit;
    memcpy(buffer, entry->data, cpylen);
    list_remove_first(list);
  }
}
