# 1 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.c"
# 1 "/Users/marko/Downloads/fcmd-2.5/banks.h" 1
# 2 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.c" 2


# 1 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1






extern void* trampoline();
extern int trampdata;
# 5 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.h" 2




struct __attribute__((__packed__)) DictEntry {
    char type;
    char keylen;
    char vallen;
    char data[];
};

struct __attribute__((__packed__)) Dictionary {
    struct DictEntry* addr;
    struct DictEntry* end;
};

extern struct Dictionary system_dict;

void dict_init(struct Dictionary* dict, char* addr);
int dict_put(struct Dictionary* dict, int type, const char* key, const char* value);
const char* dict_get(struct Dictionary* dict, int type, const char* key);
const char* dict_getncpy(struct Dictionary* dict, int type, const char* key, char* buf, int limit);
int dict_remove(struct Dictionary* dict, int type, const char* key);

typedef int (*dict_visitor_cb)(struct DictEntry*);
void dict_visit(struct Dictionary* dict, dict_visitor_cb cb);

static inline void bk_dict_init (struct Dictionary* dict, void* addr) { static const int ab_dict_init[] = {(int)(0x6000|(4<<1)), (int)(0x6000|(4<<1)), (int)dict_init}; trampdata = (int)ab_dict_init; trampoline (dict, addr); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.c" 2
# 1 "/Users/marko/Downloads/fcmd-2.5/b1_strutil.h" 1



# 1 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 1






# 1 "/Users/marko/Downloads/fcmd-2.5/banking.h" 1
# 8 "/Users/marko/Downloads/fcmd-2.5/libti99/string.h" 2


int strlen(const char *s);



int atoi(char *s);


char *strcpy(char *d, const char *s);



int strcmp(const char *s1, const char *s2);



int memcmp(const void *s1, const void *s2, int n);


void *memcpy(void *dest, const void *src, int cnt);


void *memset(void *dest, int src, int cnt);



char *uint2str(unsigned int x);



char *int2str(int x);



char* uint2hex(unsigned int x);




void gets(char *buf, int maxlen);


static inline int bk_strlen (const char *s) { static const int ab_strlen[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strlen}; trampdata = (int)ab_strlen; return (int)trampoline (s); }
static inline int bk_atoi (char *s) { static const int ab_atoi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)atoi}; trampdata = (int)ab_atoi; return (int)trampoline (s); }
static inline char * bk_strcpy (char *d, const char *s) { static const int ab_strcpy[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strcpy}; trampdata = (int)ab_strcpy; return (char *)trampoline (d, s); }
static inline char * bk_uint2str (unsigned int x) { static const int ab_uint2str[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)uint2str}; trampdata = (int)ab_uint2str; return (char *)trampoline (x); }
static inline char * bk_uint2hex (unsigned int x) { static const int ab_uint2hex[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)uint2hex}; trampdata = (int)ab_uint2hex; return (char *)trampoline (x); }
# 5 "/Users/marko/Downloads/fcmd-2.5/b1_strutil.h" 2


int strcmp(const char* a, const char* b);
int strcmpi(const char* a, const char* b);
int str_equals(char* a, char* b);
int indexof(const char* str, int c);
int lindexof(const char* str, int c, int start);
int str_startswith(const char* str, const char* prefix);
int str_endswith(const char* str, const char* suffix);
int basicToCstr(const char* str, char* buf);
char* strtok(char *str, int delim);
char* strtokpeek(char* str, int delim);
void strset(char* buffer, int value, int limit);
char* strcat(char* dst, const char* add);
char* strncpy(char* dest, char* src, int limit);
void strpad(char* dest, int limit, int pad);
int htoi(char* s);

extern char *lasts;

static inline void setstrtok(char *str)
{
    lasts = str;
}


extern char str2ram_buf[128];

static inline char* str2ram(const char* str) {
    memcpy(str2ram_buf, str, 128);
    return str2ram_buf;
}

static inline int bk_strcmp (const char *a, const char *b) { static const int ab_strcmp[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strcmp}; trampdata = (int)ab_strcmp; return (int)trampoline (a, b); }
static inline int bk_strcmpi (const char *a, const char *b) { static const int ab_strcmpi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strcmpi}; trampdata = (int)ab_strcmpi; return (int)trampoline (a, b); }
static inline int bk_str_equals (const char *a, const char *b) { static const int ab_str_equals[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)str_equals}; trampdata = (int)ab_str_equals; return (int)trampoline (a, b); }
static inline int bk_indexof (const char *str, int c) { static const int ab_indexof[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)indexof}; trampdata = (int)ab_indexof; return (int)trampoline (str, c); }
static inline int bk_lindexof (const char *str, int c, int start) { static const int ab_lindexof[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)lindexof}; trampdata = (int)ab_lindexof; return (int)trampoline (str, c, start); }
static inline int bk_str_startswith (const char *str, const char *prefix) { static const int ab_str_startswith[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)str_startswith}; trampdata = (int)ab_str_startswith; return (int)trampoline (str, prefix); }
static inline int bk_str_endswith (const char *str, const char *suffix) { static const int ab_str_endswith[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)str_endswith}; trampdata = (int)ab_str_endswith; return (int)trampoline (str, suffix); }
static inline int bk_basicToCstr (const char *str, char *buf) { static const int ab_basicToCstr[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)basicToCstr}; trampdata = (int)ab_basicToCstr; return (int)trampoline (str, buf); }
static inline char * bk_strtok (char *str, int delim) { static const int ab_strtok[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strtok}; trampdata = (int)ab_strtok; return (char *)trampoline (str, delim); }
static inline char * bk_strtokpeek (char *str, int delim) { static const int ab_strtokpeek[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strtokpeek}; trampdata = (int)ab_strtokpeek; return (char *)trampoline (str, delim); }
static inline void bk_strset (char *buffer, int value, int limit) { static const int ab_strset[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strset}; trampdata = (int)ab_strset; trampoline (buffer, value, limit); }
static inline char * bk_strcat (char *dst, const char *add) { static const int ab_strcat[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strcat}; trampdata = (int)ab_strcat; return (char *)trampoline (dst, add); }
static inline char * bk_strncpy (char *dest, char *src, int limit) { static const int ab_strncpy[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strncpy}; trampdata = (int)ab_strncpy; return (char *)trampoline (dest, src, limit); }
static inline void bk_strpad (char *dest, int limit, int pad) { static const int ab_strpad[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)strpad}; trampdata = (int)ab_strpad; trampoline (dest, limit, pad); }
static inline int bk_htoi (char* s) { static const int ab_htoi[] = {(int)(0x6000|(1<<1)), (int)(0x6000|(4<<1)), (int)htoi}; trampdata = (int)ab_htoi; return (int)trampoline (s); }
# 6 "/Users/marko/Downloads/fcmd-2.5/b4_dictionary.c" 2


struct Dictionary system_dict;

void dict_init(struct Dictionary* dict, char* addr) {
  dict->addr = (struct DictEntry*) addr;
  dict->end = (struct DictEntry*) addr;
}

inline int dict_entry_size(struct DictEntry* entry) {
    return 5 + entry->keylen + entry->vallen;
}

struct DictEntry* dict_entry(struct Dictionary* dict, int type, const char* key) {
    struct DictEntry* cursor = dict->addr;
    while (cursor < dict->end) {
        if (cursor->type == type && bk_strcmp(key, cursor->data) == 0) {
            return cursor;
        }
        cursor = (struct DictEntry*) (((char*) cursor) + dict_entry_size(cursor));
    }
    return 0;
}

void dict_visit(struct Dictionary* dict, dict_visitor_cb cb) {
    struct DictEntry* cursor = dict->addr;
    while (cursor < dict->end) {
        if (cb(cursor)) {
            return;
        }
        cursor = (struct DictEntry*)(((char*)cursor) + dict_entry_size(cursor));
    }
}

int dict_put(struct Dictionary* dict, int type, const char* key, const char* value) {
    dict_remove(dict, type, key);

    struct DictEntry* newspace = dict->end;
    int keylen = bk_strlen(key);
    int vallen = bk_strlen(value);
    newspace->type = type;
    newspace->keylen = keylen;
    newspace->vallen = vallen;
    bk_strncpy(newspace->data, (char*) key, keylen);
    bk_strncpy(newspace->data + (keylen + 1), (char*) value, vallen);
    dict->end = (struct DictEntry*) (((char*) newspace) + dict_entry_size(newspace));
    return 1;
}

const char* dict_get(struct Dictionary* dict, int type, const char* key) {
    struct DictEntry* cursor = dict_entry(dict, type, key);
    if (cursor != 0) {
        return cursor->data + cursor->keylen + 1;
    }
    return 0;
}

const char* dict_getncpy(struct Dictionary* dict, int type, const char* key, char* buf, int limit) {
    const char* value = dict_get(dict, type, key);
    if (value != 0) {
        bk_strncpy(buf, (char*) value, limit);
        return buf;
    }
    return 0;
}

int dict_remove(struct Dictionary* dict, int type, const char* key) {
    struct DictEntry* cursor = dict_entry(dict, type, key);
    if (cursor != 0) {

        int entry_size = dict_entry_size(cursor);
        char* dst = (char*) cursor;
        char* src = dst + entry_size;
        memcpy(dst, src, ((char*)dict->end) - src);
        dict->end = (struct DictEntry*) (((char*)dict->end) - entry_size);
        bk_strset((char*) dict->end, 0, entry_size);
        return 1;
    }
    return 0;
}
