/* gets.c
   This program tests gets functions with sound and other features.
   change log:
   01/23/2025 initial version
   02/28/2025 update for removal of 80x30 mode
   05/03/2025 added dylib reference
   06/05/2025 signal handling
   06/07/2025 moved calls to dylib
   06/09/2025 handle ctrl-d
   06/11/2025 removed sound.h include
*/

#include <stdlib.h>
#include <console.h>
#include <stdio.h>
#include <soundqueue.h>
#include <sequencer.h>
#include <sounds.h>
#include <speechqueue.h>
#include <dylib.h>

int h_mario;

int dir[4];

double d1, d2, d3;

void sprite_monitor () {

   int y, x;
   for (int i = 0; i < 4; i++) {
      console_sprite_get_position (i, &y, &x);
      switch (dir[i]) {
         case 0:
            if (x >= 247) {
               dir[i] = 1;
               console_sprite_set_motion (i, 1, 0);
            }
            break;
         case 1:
            if (y >= 183) {
               dir[i] = 2;
               console_sprite_set_motion (i, 0, -1);
            } 
            break;
         case 2:
            if (x <= 0) {
               dir[i] = 3;
               console_sprite_set_motion (i, -1, 0);
            }
            break;
         case 3:
            if (y <= 0) {
               dir[i] = 0;
               console_sprite_set_motion (i, 0, 1);
            }
            break;
         default:
            break;
      }
   }

}

void sprite_start () {
   for (int i = 0; i < 4; i++) {
      dir[i] = i;
   }
   console_sprite_set_values (0, 'A', 2, 0, 127, 0, 1);
   console_sprite_set_values (1, 'B', 6, 97, 247, 1, 0);
   console_sprite_set_values (2, 'C', 10, 183, 127, 0, -1);
   console_sprite_set_values (3, 'D', 14, 96, 0, -1, 0);

   sequencer_add (sprite_monitor);
}

void sprite_stop () {
   console_sprite_set_motion (0, 0, 0);
   console_sprite_set_motion (1, 0, 0);
   console_sprite_set_motion (2, 0, 0);
   console_sprite_set_motion (3, 0, 0);

   console_sprite_set_position (0, 192, 0);
   console_sprite_set_position (1, 192, 0);
   console_sprite_set_position (2, 192, 0);
   console_sprite_set_position (3, 192, 0);

   sequencer_remove (sprite_monitor);
}

void sound_monitor () {
   if (soundqueue_play_is_done ()) {
      soundqueue_play (h_mario);
   }
}

void sound_start () {
   char *p;
   int len;

   sounds_get_seq_supermario (&p, &len);
   h_mario = soundqueue_load (p, len, SOUNDQUEUE_PREEMPTION_RULE_CONTINUE);

   sequencer_add (sound_monitor);
}

void sound_stop () {
   sequencer_remove (sound_monitor);
}

void speech_monitor () {
   if (speechqueue_is_empty ()) {
      int v[] = {VOCAB_TEXAS_INSTRUMENTS, VOCAB_T, VOCAB_I, VOCAB_NINETY, VOCAB_NINE, VOCAB_4, VOCAB_A_ay, 0};
      speechqueue_say_v (v);
   }
   d3 = d1 * d2;
}

void speech_start () {
   sequencer_add (speech_monitor);
}

void speech_stop () {
   sequencer_remove (speech_monitor);
}

int recover_display_mode;
int recover_display_rows;

void prog_term () {
   sound_stop ();
   speech_stop ();
   sprite_stop ();

   // restore settings before exiting
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls ();
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   char s[80];
   int i;

   // save the current display mode
   console_display_get_mode (&recover_display_mode, &recover_display_rows);

   console_display_set_mode (DISPLAY_MODE_STANDARD, DISPLAY_ROWS_24);
   console_standard_set_default_color ();
   console_cls ();

   dylib.atexit (prog_term);

   sound_start ();
   speech_start ();
   sprite_start ();

   dylib.fputs ("enter 3 lines of text: ", stdout);

   for (i = 0; i < 3; i++) {
      if (!dylib.fgets (s, sizeof (s), stdin)) {
         break;
      }
   }

   return 0;
}
