/* id.c
   This program prints the user identity
   change log:
   11/06/2023 initial version
   11/11/2023 added initial text "id="
   12/10/2023 added reference to conversion.h
   03/01/2024 updated to use dylib
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

const char *msg1 = "id=";
const char *msg2 = "(";
const char *msg3 = ")\n";

int main (int argc, char *argv[]) {
   dylib.fputs (msg1, stdout);
   dylib.fputs (dylib.int2str (getuid ()), stdout);
   dylib.fputs (msg2, stdout);
   dylib.fputs (getlogin (), stdout);
   dylib.fputs (msg3, stdout);
   return 0;
}
