/* images.c
   This program demonstrates the use of the image package.
   change log:
   11/16/2023 initial version
   12/10/2023 added reference to conversion.h
   03/01/2024 updated to use dylib
   01/17/2025 added call to image_init
   01/20/2025 updated fputs to dylib
*/

#include <stdio.h>
#include <image.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

const char *msg1 = "ids remaining: ";
const char *cr   = "\n";

int main (int argc, char *argv[]) {

   const char *ti_logo[] = {
      "-------XXXXXXX----------",
      "------XX-----X--X-------",
      "------XX-----X-X-X------",
      "------XX-----X-X-X------",
      "------XX-----X--X-------",
      "------XX-----XX---------",
      "------XX------X-----XX--",
      "------XX----XX-----X--X-",
      "XXXXXXXX---XX--XX-XXX-X-",
      "X---------X----XX---X-X-",
      "XX--------X----XX---X-X-",
      "-X--------XXXX-XX-XXX-X-",
      "-XX----------X-XX-X----X",
      "--XXX--------X-XX-X----X",
      "---XXX-------X-XX-X----X",
      "----XXX-XX---X----X---X-",
      "------XXXXX---X--X--XX--",
      "-------X--XX---XX--X----",
      "-----------X------X-----",
      "-----------XX----X------",
      "------------XX---X------",
      "-------------XXX--X-----",
      "--------------XXXXX-----",
      "------------------------",
      NULL
   };

   const char *monster[] = {
      "------XXXXXXXXXXX------",
      "---XXXXXXXXXXXXXXXXX---",
      "-XXXXXXXXXXXXXXXXXXXXX-",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXX------XXXXX------XXX",
      "XX--X-----XXX--X-----XX",
      "XX--X-----XXX--X-----XX",
      "XX--XXX---XXX--XX----XX",
      "XX--------XXX--------XX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XX-XXX-XXX-XXX-XXX-XXXX",
      "XXX-X-X-X-X-X-X-X-X-XXX",
      "XXXX-XXX-XXX-XXX-XXX-XX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXX-XXXXX-XXXXX-XXXXX",
      "XXXX---XXX---XXX---XXXX",
      "XXX-----X-----X-----XXX",
      NULL
   };

   const char *happy_face[] = {
      "------XXXXXXXXXXX------",
      "---XXXXXXXXXXXXXXXXX---",
      "-XXXXXXXXXXXXXXXXXXXXX-",
      "-XXXXXXXXXXXXXXXXXXXXX-",
      "XXXXXX--XXXXXXX--XXXXXX",
      "XXXXX----XXXXX----XXXXX",
      "XXXXXX--XXXXXXX--XXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXXXXXXXXXXXXXXXXXXXX",
      "XXXXX--XXXXXXXXX--XXXXX",
      "XXXXX--XXXXXXXXX--XXXXX",
      "XXXXXX--XXXXXXX--XXXXXX",
      "XXXXXXX---------XXXXXXX",
      "-XXXXXXXXXXXXXXXXXXXXX-",
      "-XXXXXXXXXXXXXXXXXXXXX-",
      "---XXXXXXXXXXXXXXXXX---",
      "------XXXXXXXXXXX------",
      NULL
   };

   const char *big_happy_face[] = {
      "----------XXXXXXXXXXXXXXXXXXXXXXXXXXXX----------",
      "------XXXX----------------------------XXXX------",
      "----XX------------------------------------XX----",
      "---X----------------------------------------X---",
      "--X------------------------------------------X--",
      "--X------------------------------------------X--",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X---------------X---------------X--------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X---------------X---------------X--------------X",
      "X----------------X-------------X---------------X",
      "X-----------------XXXXXXXXXXXXX----------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "X----------------------------------------------X",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "-X--------------------------------------------X-",
      "--X------------------------------------------X--",
      "--X------------------------------------------X--",
      "---X----------------------------------------X---",
      "----XX------------------------------------XX----",
      "------XXXX----------------------------XXXX------",
      "----------XXXXXXXXXXXXXXXXXXXXXXXXXXXX----------",
      NULL
   };

   image_t image_logo, image_monster, image_happy_face, image_big_happy_face;
   int y, x;
   int r;

   dylib.fputs ("\fImage package examples\n", stdout);

   image_init ();

   r = image_generate (&image_logo, ti_logo);
   if (r) {
      dylib.fputs ("error generating 1\n", stdout);
   }
   r = image_generate (&image_monster, monster);
   if (r) {
      dylib.fputs ("error generating 2\n", stdout);
   }
   r = image_generate (&image_happy_face, happy_face);
   if (r) {
      dylib.fputs ("error generating 3\n", stdout);
   }
   r = image_generate (&image_big_happy_face, big_happy_face);
   if (r) {
      dylib.fputs ("error generating 4\n", stdout);
   }

   for (y = 1; y < 20; y++) {
      for (x = 0; x < 28; x++) {
         image_draw (&image_logo, y, x);
         image_draw (&image_logo, 20 - y, x);
         image_draw (&image_logo, y, 28 - x);
         image_draw (&image_logo, 20 - y, 28 - x);
         image_clear (&image_logo, y, x);
         image_clear (&image_logo, 20 - y, x);
         image_clear (&image_logo, y, 28 - x);
         image_clear (&image_logo, 20 - y, 28 - x);
      }
   }
   image_draw (&image_logo, 7, 0);
   image_draw (&image_monster, 7, 7);
   image_draw (&image_happy_face, 7, 14);
   image_draw (&image_big_happy_face, 7, 21);

   dylib.fputs (msg1, stdout);
   dylib.fputs (dylib.int2str (image_ids_remaining ()), stdout);
   dylib.fputs (cr, stdout);

   return 0;
}
