/* assert.h
   This header defines the assert macro.
   change log:
   07/01/2023 initial version
   07/22/2023 moved assert_handle to assert_private.h
   11/23/2023 added comments
*/

#ifndef ASSERT_H
#define ASSERT_H

#include <assert_private.h>

// asserts the truth of an expression and reports when the expression is false
#define assert(expr) \
    if (expr) \
        {} \
    else \
        assert_handle (__FILE__, __LINE__, #expr)

#endif
