/* cache.h
   This header defines the methods for a cache that persists during a running instance of the operating system. 
   limitations:
   This package provides a stand-in for what would better be handled in shared memory. The limitations of the TI-99/4A system
   essentially preclude such capability.
   change log:
   11/03/2023 initial version
*/

#ifndef CACHE_H
#define CACHE_H

// returns the cached value for a key. Return values are 0 on success, non-zero when the key isn't present
int cache_get (int key, int *val);

// writes a cached value for a key. Return values are 0 on success, non-zero when the key/value pair cannot be written
int cache_put (int key, int val);

#endif
