/* conversion.h
   This header defines mathmatical conversions.
   change log:
   07/01/2023 initial version
   05/07/2025 renamed ptoa to ptoa_upper; added ptoa_lower
*/

#ifndef CONVERSION_H
#define CONVERSION_H

// converts a double into a string representation
const char *ftoa (double d);

// converts an integer to a double
double itof (int k);

// converts an unsigned integer to a double
double uitof (unsigned int k);

char *uint2str (unsigned int x);
char *int2str (int x);
char* uint2hex (unsigned int x);

// converts a double to integer
int ftoi (double d);

// converts a double to a long
long ftol (double d);

// converts a double to a long
long __fixdfdi (double d);

// converts a long to a double
double ltof (long l);

// converts a double to an unsigned long
unsigned long ftoul (double d);

// converts an unsigned long to a double
double ultof (unsigned long ul);

// converts a long into a string representation
const char *ltoa (long x);

// converts an unsigned long into its string representation
const char *ultoa (unsigned long x);

// converts a void pointer to memory address into a hex string representation for the specified width
const char *ptoa_upper (void *d, int width);
const char *ptoa_lower (void *d, int width);

// converts an ASCII charcter into a nibble
unsigned char c2i (unsigned char c);

// converts a nibble into an ASCII character
unsigned char i2c (unsigned char i);

// negates a float (double)
double fnegate (double d);

#endif
