/* dirent.h
   This header defines the methods for reading directories and file attributes.
   limitations:
   This implementation supports reading only one directory at a time, which 
   complicates otherwise easy to implement directory recursion. As it is, the
   TI has very limited file support (multiple open files / DSRs) so no big 
   loss.
   change log:
   07/01/2023 initial version
   12/10/2023 updated to use FILENAME_MAX for directory and volume name lengths
   02/24/2024 broad support for shared libraries
*/

#ifndef DIRENT_H
#define DIRENT_H

#include <files.h>
#include <stdbool.h>
#include <stdio.h>

// the directory entry structure
struct dirent {
   double d_reclen;             // length of this record
   double d_type;               // type of file
   double d_sectors;            // number of sectors used
   bool   d_protected;          // whether the file is protected
   char   d_name[FILENAME_MAX]; // filename
};

// the directory structure
typedef struct {
   FILE *df;                  // a regular file is used
   char volume[FILENAME_MAX]; // volume name
   double total_sectors;      // total sectors in the volume
   double free_sectors;       // total free sectors in the volume
   struct dirent entry;       // the current directory entry
} DIR;

// opens the specified directory and returns a directory stream
DIR *opendir (const char *path);

// reads a directory entry and returns a pointer to it
struct dirent *readdir (DIR *dirp);

// closes the directory stream
int closedir (DIR *dirp);

#endif
