/* image.h
   This package provides a simple to use graphics interface that generates a multi-character image displayable on the screen.
   The user defined image is defined as a set of strings filled with dashes and X's. These get converted into an internal image
   array of characters whose character definitions are set for displaying the image. The portions of the image that result in non-
   set pixels are simply set to ascii character 0, which is expected to be blank--a variation on sparse matrices. This package supports
   the standard, text and F18A text80 modes.
   limitations:
   The package is limited to 156 characters, range 0x00 to 0x1d and 0x80 to 0xff.
   change log:
   11/16/2023 initial version
*/

#ifndef IMAGE_H
#define IMAGE_H

#define IMAGE_CHAR_HEIGHT_MAX 8
#define IMAGE_CHAR_WIDTH_MAX  8
#define IMAGE_CHAR_DEF_SIZE   8

typedef struct {
   int height;
   int width;
   unsigned char id[IMAGE_CHAR_HEIGHT_MAX][IMAGE_CHAR_WIDTH_MAX];
} image_t;

// resets the character definitions to be used
void image_init ();

// generates a displayable image from the text bitmap
int image_generate (image_t *image, const char *text_bitmap[]);

// draws an image on the screen at the specific coordinates
void image_draw (image_t *image, int y, int x);

// clears an image from the screen at the specified coordinates
void image_clear (image_t *image, int y, int x);

// returns the number of character ids remaining
int image_ids_remaining ();

#endif
