/* accts_private.c
   This package provides user account management support.
   change log:
   11/25/2023 initial version
   09/29/2025 adjusted max users to 10
*/

#ifndef ACCTS_PRIVATE_H
#define ACCTS_PRIVATE_H

#include <stdio.h>
#include <unistd_private.h>

typedef struct {
   int uid;
   int gid;
   char name[10];
   char cipher[18];
   char long_name[32];
   char home_dir[FILENAME_MAX];
   char shell[FILENAME_MAX];
} acct_t;

typedef struct {
   acct_t *acct[10];
   int count;
} accts_t;

const char *accts_get_passwd_file_path ();

void accts_init (accts_t *accts);

int accts_read (accts_t *accts);

void accts_free (accts_t *accts);

void accts_write_raw (const accts_t *accts, FILE *f);

int accts_write (const accts_t *accts);

int accts_get_next_uid (const accts_t *accts);

int accts_get_username_index (const accts_t *accts, const char *name);

int accts_add_user (accts_t *accts, const char *name, const char *cipher, const char *long_name);

int accts_rm_user (accts_t *accts, const char *name);

int accts_get_value (accts_t *accts, const char *name, int field_id, char *value_s, int *value_i);

int accts_set_value (accts_t *accts, const char *name, int field_id, const char *value_s, int value_i);

#endif
