/* batch_private.h
   change history
   05/31/2025 initial version
   06/03/2025 added batch_note_double and batch_note_single
              augmented batch_t to support recursive copy/remove verbosity
*/

#ifndef BATCH_PRIVATE_H
#define BATCH_PRIVATE_H

#include <stdio.h>

typedef struct {
   FILE *f;
   bool summary_verbose;
   bool recursive_verbose;
   bool debug;
   char path[FILENAME_MAX];
} batch_t;

batch_t batch_create (const char *path, bool summary_verbose, bool recursive_verbose, bool debug);

int batch_close (batch_t *batch);

int batch_execute (batch_t *batch);

void batch_remove (batch_t *batch);

void batch_note (batch_t *batch, const char *source, const char *target);
void batch_note_double (batch_t *batch, const char *source, const char *target);
void batch_note_single (batch_t *batch, const char *source);

void batch_file_cp (batch_t *batch, const char *source, const char *target, int file_type);

void batch_file_rm (batch_t *batch, const char *path);

void batch_file_rename (batch_t *batch, const char *source, const char *target);

void batch_mkdir (batch_t *batch, const char *path);

void batch_rmdir (batch_t *batch, const char *path);

void batch_dir_rename (batch_t *batch, const char *source, const char *target);

#endif
