/* cache_private.h
   This header defines the cache private data and methods.
   change log:
   02/18/2024 added header
   02/22/2024 changed name of dylib
   02/24/2024 broad changes for introduction of the dylib
   02/25/2024 added dir_in_use
   04/09/2024 removed _start
   01/07/2025 removed cache validity flag
   01/12/2025 updated sams exists to sams page count
   01/12/2025 removed rom
   01/18/2025 changed sams_page_count to int
              added sams_pages_in_use
   01/22/2025 performance improvements
   01/24/2025 removed dsr_hardware_t
   01/25/2025 added sams_status_t
   02/08/2025 added gpu method caching
   04/10/2025 added sram_is_expanded
   04/21/2025 added external keyboard and mouse support
   06/05/2025 added signal handler types
   07/12/2025 added shared memory data
*/

#ifndef CACHE_PRIVATE_H
#define CACHE_PRIVATE_H

#include <unistd_private.h>
#include <console_private.h>
#include <stdio_private.h>
#include <stdlib_private.h>
#include <sequencer_private.h>
#include <spinner_private.h>
#include <sams_private.h>
#include <gpu_private.h>
#include <signal_private.h>
#include <shm_private.h>

// maximum number of key value pairs
#define MAX_KV_ENTRIES 4

// the key value type
typedef struct {
   int key;
   int val;
} kv_t;

// the cache
typedef struct {
   kv_t            kv[MAX_KV_ENTRIES];
   int             num_kvs;

   dsr_list_t      dsr_list;

   proc_list_t     proc_list;
   login_t         login;

   dsr_info_t      dsr_info;
   file_info_t     file_info;
   atexit_t        atexit_info;             // atexit data

   sequences_t     sequences_info;

   spinner_state_t spinner_state;

   bool            dir_in_use;

   sams_status_t   sams;
// int             sams_page_count;
// int             sams_pages_in_use;

   gpu_method_t    gpu_method;

   sig_handlers_t  signal_handler;

   shm_t           shm;
} cache_t;

// the scratch cache
typedef struct {
   console_state_t console;
   bool sram_is_expanded;
   bool have_external_keyboard;
   bool have_external_mouse;
} cachex_t;

// the cache objects
extern cache_t cache;
extern cachex_t cachex;

// initializes the cache
void cache_init ();

#endif
