/* dsrl2_private.h
   This package provides the DSR L2 method macros and headers. Descriptions and reference data is available at http://hexbus.com/ti99geek.
   change log:
   05/24/2025 initial version
*/

#ifndef DSRL2_PRIVATE_H
#define DSRL2_PRIVATE_H

#define DSRL2_SCRATCH_UNIT     *((volatile unsigned char *) 0x834c)
#define DSRL2_SCRATCH_PATHNAME *((volatile unsigned int *) 0x834e)
#define DSRL2_SCRATCH_FILE     *((volatile unsigned int *) 0x834e)
#define DSRL2_SCRATCH_FILE_NEW *((volatile unsigned int *) 0x834e)
#define DSRL2_SCRATCH_FILE_OLD *((volatile unsigned int *) 0x8350)
#define DSRL2_SCRATCH_DIR      *((volatile unsigned int *) 0x834e)
#define DSRL2_SCRATCH_DIR_NEW  *((volatile unsigned int *) 0x834e)
#define DSRL2_SCRATCH_DIR_OLD  *((volatile unsigned int *) 0x8350)
#define DSRL2_SCRATCH_ERROR    *((volatile unsigned char *) 0x8350)

#define DSRL2_OP_SECTOR           0x00
#define DSRL2_OP_PROTECT          0x02
#define DSRL2_OP_RENAME_FILE      0x03
#define DSRL2_OP_INPUT            0x04
#define DSRL2_OP_OUTPUT           0x05
#define DSRL2_OP_SETDIR           0x07
#define DSRL2_OP_MKDIR            0x08
#define DSRL2_OP_RMDIR            0x09
#define DSRL2_OP_RENAME_FILE_DIR  0x0A

char *dsrl2_get_error_description (unsigned char error);

void dsrl2_call_method (int crubase, int addr, int link);

unsigned char dsrl2_get_device (const char * ti_path);

unsigned int dsrl2_get_final_method (unsigned char opcode, unsigned char device);

unsigned char dsrl2_get_unit (const char *ti_path);

unsigned int dsrl2_get_cru (const char *ti_path);

void dsrl2_dirname_ti (char *dirname, const char *ti_path);

void dsrl2_basename_ti (char *basename, const char *ti_path);

int dsrl2_get_op_addr_link (unsigned int cru, unsigned char device, char opcode, unsigned int *addr, unsigned int *link);

int dsrl2_collect_info (const char *path, unsigned int *cru, unsigned char *device, unsigned char *unit, char *dirname, char *basename);

int dsrl2_mkdir (const char *path);

int dsrl2_rmdir (const char *path);

int dsrl2_rename_directory (const char *path_src, const char *path_tgt);

int dsrl2_rename_file (const char *path_src, const char *path_tgt);

#endif
