/* gpu_private.h
   This header defines the types, definitions and methods used for GPU method invocation.
   change history
   02/08/2025 initial version
   02/15/2025 added addr_watermark, gpu_clear_methods_after_watermark, gpu_set_methods_watermark;
   02/18/2025 added vdp_gpu_method_addr_first to gpu_init
*/

#ifndef GPU_PRIVATE_H
#define GPU_PRIVATE_H

#include <gpu.h>

typedef struct {
   char addr[2];
} gpu_method_addr_t;

typedef struct {
   gpu_method_addr_t id[16];
   unsigned int addr_watermark;
   unsigned int addr_next;
   unsigned int addr_last;
   int gpu_is_present;
} gpu_method_t;

int gpu_init (unsigned int vdp_gpu_method_addr_first, unsigned int region_size);

#define GPU_EXISTS               0
/* DELETE
#define GPU_SCROLL_TEXT_80_X_30  1
#define GPU_SCROLL_TEXT_80_X_24  2
#define GPU_SCROLL_TEXT_40_X_24  3
#define GPU_SCROLL_TEXT_32_X_24  4
*/

#define GPU_CLS                  5
#define GPU_SCROLL               6

#define GPU_EXISTS_VDP_ADDR 0x2000
#define GPU_ROWS_VDP_ADDR   0x2002
#define GPU_COLS_VDP_ADDR   0x2004

// these methods are to be used exclusively by gpu_init ():

// initializes the GPU method list
void gpu_init_method_list (unsigned int addr, unsigned int region_size);

// executes a GPU method without testing for prescense of the GPU
void gpu_execute_unconditionally (int method_id);

// deallocates methods added after the watermark was set
void gpu_clear_methods_after_watermark ();

// sets the gpu methods watermark
void gpu_set_methods_watermark ();

#endif
