/* kvstore_private.h
   This header defines the key-value pair storage types and methods.
   change history
   06/14/2025 initial version
*/

#ifndef KVSTORE_PRIVATE_H
#define KVSTORE_PRIVATE_H

// key/value type
typedef struct {
   char key[10];
   char val[10];
} keyval_t;

// key/value store type
typedef struct {
   keyval_t keyval[10];
   int count;
} kvstore_t;

// initializes a kvstore type
void kvstore_init (kvstore_t *kvstore);

// reads a kvstore from the specified path. returns 0 on success, non-zero on failure
int kvstore_read (kvstore_t *kvstore, const char *path);

// writes a dvstore to the specified path. returns 0 on success, non-zero on failure
int kvstore_write (kvstore_t *kvstore, const char *path);

// returns the value for a key in a kvstore. returns NULL if the key is not found
const char *kvstore_get (kvstore_t *kvstore, const char *key);

// sets the value for a key in a kvstore. returns zero on success, non-zero on failure
int kvstore_put (kvstore_t *kvstore, const char *key, const char *val);

#endif
