/* rom_private.h
   This method provides types, values and methods for rom use.
   change history
   06/16/2025 added header
              added switch addresses for page 3
              removed experimental page
*/

#ifndef ROM_PRIVATE_H
#define ROM_PRIVATE_H

typedef struct __attribute__((__packed__)) {
   void         *next;    // romentrylist_t *
   unsigned int *routine;
} romentrylist_t;

typedef struct __attribute__((__packed__)) {
   void         *next;    // romnamelist_t *
   unsigned int routine;
   char         name[42]; // length byte + the name itself
} romnamelist_t;

typedef struct __attribute__((__packed__)) {
   unsigned char  flag;         // 0xAA
   unsigned char  version;      // 0x01
   unsigned char  numprogs;     // 0x00
   unsigned char  notused;      // 0x00
   romentrylist_t *poweruplist; // 0x0000
   romnamelist_t  *proglist;    // cartridge-based programs
   romnamelist_t  *dsrlist;     // dsr list
   romnamelist_t  *subproglist; // programs for TI Basic (and XB?)
} romstdheader_t;

// set the rom pages
#define BSWITCH_0 *((volatile unsigned int*)0x6000)
#define BSWITCH_1 *((volatile unsigned int*)0x6002)
#define BSWITCH_2 *((volatile unsigned int*)0x6004)
#define BSWITCH_3 *((volatile unsigned int*)0x6006)

#define ROM_PAGE_SET_STANDARD BSWITCH_1

#endif
