/* sequencer_private.h
   This header defines the types and methods associated with the sequencer.
   change log:
   02/24/2024 added header
*/

#ifndef SEQUENCER_PRIVATE_H
#define SEQUENCER_PRIVATE_H

// maximum number of sequence methods that can be handled
#define SEQUENCES_MAX 10

// definition of a sequencer method
typedef void sequencer_method_t (void);

// sequences type
typedef struct {
   sequencer_method_t *method[SEQUENCES_MAX];
   int count;
   int throttle;
} sequences_t;

// initializes the sequencer
void sequencer_init ();

// updates the sequencer, calling all the sequence methods
void sequencer_update ();

#endif
