/* shm_private.h
   This header defines the types and methods used by the kernel for shared memory.
   change history
   07/12/2025 initial version
*/

#ifndef SHM_PRIVATE_H
#define SHM_PRIVATE_H

#include <sys/shm.h>

#define SHM_REGION_MAX 8

typedef struct {
   key_t key;
   int region[SHM_REGION_MAX];   // these are regions defined in SAMS (6 SAMS pages), thus 4KB * 6 * 8 = 192KB maximum can be allocated for a shared memory segment
   bool in_use;
} shm_entry_t;

#define SHM_ENTRIES_MAX 3        // max number of shared memory segments

typedef struct {
   shm_entry_t entry[SHM_ENTRIES_MAX];
} shm_t;

int kernel_shmget (key_t key, long size, int shmflg);

void *kernel_shmat (int shmid, const void *shmaddr, int shmflg, int page);

int kernel_shmdt (const void *shmaddr);

int kernel_shmctl (int shmid, int cmd, struct shmid_ds *buf);

#endif

