/* signal_private.h
   This header defines the private types and methods for signal handling.
   change history
   06/05/2025 initial version
*/

#ifndef SIGNAL_PRIVATE_H
#define SIGNAL_PRIVATE_H

#include <signal.h>

typedef struct {
   sig_t sighup;
   sig_t sigint;
   sig_t sigkill;
   sig_t sigusr1;
   sig_t sigusr2;
/*
   void (*sighup) (int sig);
   void (*sigint) (int sig);
   void (*sigkill) (int sig);
   void (*sigusr1) (int sig);
   void (*sigusr2) (int sig);
*/
} sig_handlers_t;

void signal_default_handler (int sig);

void signal_cache_init ();

#endif
