/* soundqueueprivate.h
   This header defines the types and methods associated with the soundqueue.
   change log:
   02/24/2024 added header
   06/11/2025 added SOUND_CNT
*/

#ifndef SOUNDQUEUE_PRIVATE_H
#define SOUNDQUEUE_PRIVATE_H

#include <stdbool.h>

#define TONE1_VOL      0x90
#define TONE2_VOL      0xB0
#define TONE3_VOL      0xD0
#define NOISE_VOL      0xF0
#define TONE1_FREQ     0x80
#define TONE2_FREQ     0xA0
#define TONE3_FREQ     0xC0
#define NOISE_MODE     0xE0

#define SOUND_CNT      *((volatile unsigned char*)0x83ce)
#define SOUND_VDP      *((volatile unsigned char*)0x83fd)
#define SOUND_PTR      *((volatile unsigned int*)0x83cc)
#define SOUND_VDP_MASK 0x01

inline void SET_SOUND_PTR (unsigned int x) { SOUND_PTR = x; }
inline void SET_SOUND_VDP () { SOUND_VDP |= SOUND_VDP_MASK; }
inline void START_SOUND (){ SOUND_CNT = 1; }

#define VDP_SOUND_BUFFER_ADDR 0x378A

#define SOUND_ENTRIES_NUM 8

typedef struct {
   char *saddr;
   int len;
   int pos;
   int preemption_rule;
   bool in_use;
} sound_entry_t;

typedef struct {
   int buf_len;
   int buf_max_entries;
   int count;
   int current;
   sound_entry_t entry[SOUND_ENTRIES_NUM];
} soundqueue_info_t;

extern soundqueue_info_t soundqueue_info;

extern int h_beep;
extern int h_honk;
extern int h_tipi;

int soundqueue_count ();

void soundqueue_init ();

void soundqueue_play_update ();

void soundqueue_load_default_sounds ();

#endif
