#ifndef SPEECHQUEUE_PRIVATE_H
#define SPEECHQUEUE_PRIVATE_H

#define SPEECH_QUEUE_LENGTH 32
extern int speech_queue[SPEECH_QUEUE_LENGTH];
extern int speech_queue_read_pos;
extern int speech_queue_write_pos;

// THESE ALREADY EXIST INTERNALLY IN LIB_TI99
typedef void (*read_func)();
#define READ_WITH_DELAY ((read_func)(SAFE_READ_PAD+2))
#define SPEECH_BYTE_BOX *((volatile unsigned char*)(SAFE_READ_PAD))

void delay_asm_12();
void delay_asm_42();

// initializes the speech queue for playing speech asyncronously with sucsessive calls to speech_queue_play
void speechqueue_init ();

// plays speech asyncronously, adding words to the speech synthesizer when is has completed speaking
void speechqueue_play ();

#endif
