/* stdlib_private.h
   This header defines the types and methods associated with the stdlib.
   change log:
   02/24/2024 added header
   06/16/2025 added kernel_exit
*/

#ifndef STDLIB_PRIVATE_H
#define STDLIB_PRIVATE_H

#include <stdbool.h>

// the malloc allocation unit size
#define ALLOC_UNIT_SIZE 32                 
         
// the malloc type
typedef struct {
   unsigned int start_addr; // start address of allocatable memory
   int count;               // total number of allocation units in this region
   bool avail[];            // all the allocation units. this is open ended, and the last index is count - 1
} malloc_t;
   
// the alloc info type
typedef struct {
   malloc_t *m ;    // memory region
   int start_index; // first index                             
   int count;       // indicates the number of allocations in this block allocation 
} alloc_info_t;

#define ATEXIT_MAX 8                    // max # of atexit methods

typedef void atexit_method_t (void);    // prototype for atexit methods
typedef struct {                        // atexit type, 18 bytes
   atexit_method_t *method[ATEXIT_MAX];
   int count;
} atexit_t;

// initializes the malloc package
void malloc_init ();

void malloc_unit_set (malloc_t *m, int start_index, int count, bool value);

// initializes the atexit info
void atexit_init ();

void kernel_exit (int status);

unsigned int malloc_vdp (int len);

#endif
